/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.compute.functions;

import com.google.common.base.Function;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.savvis.vpdc.domain.VMSpec;

@Singleton
public class VMSpecToHardware
implements Function<VMSpec, Hardware> {
    @Override
    public Hardware apply(VMSpec from) {
        HardwareBuilder builder = new HardwareBuilder();
        builder.ids(from.toString());
        for (int i = 0; i < from.getProcessorCount(); ++i) {
            builder.processor(new Processor(1.0, 3.0));
        }
        builder.ram(from.getMemoryInGig() * 1024);
        builder.volume(new VolumeBuilder().type(Volume.Type.LOCAL).device(from.getBootDeviceName()).size(new Float(from.getBootDiskSize())).bootDevice(true).durable(true).build());
        for (Map.Entry<String, Integer> disk : from.getDataDiskDeviceNameToSizeInGig().entrySet()) {
            builder.volume(new VolumeBuilder().type(Volume.Type.LOCAL).device(disk.getKey()).size(new Float(disk.getValue().intValue())).durable(true).build());
        }
        return builder.build();
    }
}

