/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.FindResourceInSet;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.savvis.vpdc.domain.VM;
import org.jclouds.savvis.vpdc.util.Utils;
import org.jclouds.util.InetAddresses2;

@Singleton
public class VMToNodeMetadata
implements Function<VM, NodeMetadata> {
    public static final Map<VM.Status, NodeState> VAPPSTATUS_TO_NODESTATE = ImmutableMap.builder().put(VM.Status.OFF, NodeState.SUSPENDED).put(VM.Status.ON, NodeState.RUNNING).put(VM.Status.RESOLVED, NodeState.PENDING).put(VM.Status.UNRECOGNIZED, NodeState.UNRECOGNIZED).put(VM.Status.UNKNOWN, NodeState.UNRECOGNIZED).put(VM.Status.SUSPENDED, NodeState.SUSPENDED).put(VM.Status.UNRESOLVED, NodeState.PENDING).build();
    private final FindLocationForVM findLocationForVM;

    @Inject
    VMToNodeMetadata(FindLocationForVM findLocationForVM) {
        this.findLocationForVM = Preconditions.checkNotNull(findLocationForVM, "findLocationForVM");
    }

    @Override
    public NodeMetadata apply(VM from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.name(from.getName());
        builder.location((Location)this.findLocationForVM.apply(from));
        builder.group(ComputeServiceUtils.parseGroupFromName(from.getName()));
        try {
            builder.operatingSystem(CIMOperatingSystem.toComputeOs(from.getOperatingSystemSection()));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        builder.state(VAPPSTATUS_TO_NODESTATE.get((Object)from.getStatus()));
        Set<String> addresses = Utils.getIpsFromVM(from);
        builder.publicAddresses(Iterables.filter(addresses, Predicates.not(InetAddresses2.IsPrivateIPAddress.INSTANCE)));
        builder.privateAddresses(Iterables.filter(addresses, InetAddresses2.IsPrivateIPAddress.INSTANCE));
        return builder.build();
    }

    @Singleton
    public static class FindLocationForVM
    extends FindResourceInSet<VM, Location> {
        @Inject
        public FindLocationForVM(@Memoized Supplier<Set<? extends Location>> hardware) {
            super(hardware);
        }

        @Override
        public boolean matches(VM from, Location input) {
            return input.getId().equals(Iterables.get(from.getNetworkSection().getNetworks(), 0).getName());
        }
    }
}

