/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.savvis.vpdc.VPDCClient;
import org.jclouds.savvis.vpdc.domain.Link;
import org.jclouds.savvis.vpdc.domain.Network;
import org.jclouds.savvis.vpdc.domain.Org;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.domain.Task;
import org.jclouds.savvis.vpdc.domain.VDC;
import org.jclouds.savvis.vpdc.domain.VM;
import org.jclouds.savvis.vpdc.domain.VMSpec;
import org.jclouds.savvis.vpdc.options.GetVMOptions;
import org.jclouds.savvis.vpdc.predicates.TaskSuccess;

@Singleton
public class VPDCComputeServiceAdapter
implements ComputeServiceAdapter<VM, VMSpec, CIMOperatingSystem, Network> {
    private final VPDCClient client;
    private final RetryablePredicate<String> taskTester;
    @Inject(optional=true)
    @Named(value="savvis-symphonyvpdc.vdc-email")
    String email;

    @Inject
    public VPDCComputeServiceAdapter(VPDCClient client, TaskSuccess taskSuccess) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.taskTester = new RetryablePredicate(Preconditions.checkNotNull(taskSuccess, "taskSuccess"), 650L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<VM> createNodeWithGroupEncodedIntoName(String tag, String name, Template template) {
        String networkTierName = template.getLocation().getId();
        String vpdcId = template.getLocation().getParent().getId();
        String billingSiteId = template.getLocation().getParent().getParent().getId();
        VMSpec.Builder specBuilder = VMSpec.builder();
        specBuilder.name(name);
        specBuilder.networkTierName(networkTierName);
        specBuilder.operatingSystem((CIMOperatingSystem)CIMOperatingSystem.class.cast(template.getImage().getOperatingSystem()));
        specBuilder.processorCount(template.getHardware().getProcessors().size());
        specBuilder.memoryInGig(template.getHardware().getRam() / 1024);
        for (Volume volume : template.getHardware().getVolumes()) {
            if (volume.isBootDevice()) {
                specBuilder.bootDeviceName(volume.getDevice()).bootDiskSize(volume.getSize().intValue());
                continue;
            }
            specBuilder.addDataDrive(volume.getDevice(), volume.getSize().intValue());
        }
        Task task = this.client.getVMClient().addVMIntoVDC(billingSiteId, vpdcId, specBuilder.build());
        if (task.getError() != null) {
            throw new RuntimeException("cloud not add vm: " + task.getError().toString());
        }
        if (this.taskTester.apply(task.getId())) {
            VM vM = this.getNode(task.getResult().getHref().toASCIIString());
            ComputeServiceAdapter.NodeAndInitialCredentials<VM> nodeAndInitialCredentials = new ComputeServiceAdapter.NodeAndInitialCredentials<VM>(vM, vM.getId(), null);
            return nodeAndInitialCredentials;
        }
        throw new RuntimeException("task timed out: " + task);
    }

    @Override
    public Iterable<VMSpec> listHardwareProfiles() {
        return ImmutableSet.of(VMSpec.builder().operatingSystem(Iterables.get(this.listImages(), 0)).memoryInGig(2).addDataDrive("/data01", 25).build());
    }

    @Override
    public Iterable<CIMOperatingSystem> listImages() {
        return this.client.listPredefinedOperatingSystems();
    }

    @Override
    public Iterable<VM> listNodes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Resource org1 : this.client.listOrgs()) {
            Org org = this.client.getBrowsingClient().getOrg(org1.getId());
            for (Link vdc : org.getVDCs()) {
                VDC VDC2 = this.client.getBrowsingClient().getVDCInOrg(org.getId(), vdc.getId());
                for (Resource vApp : Iterables.filter(VDC2.getResourceEntities(), new Predicate<Resource>(){

                    @Override
                    public boolean apply(Resource arg0) {
                        return "application/vnd.vmware.vcloud.vApp+xml".equals(arg0.getType());
                    }
                })) {
                    builder.add(this.client.getBrowsingClient().getVMInVDC(org.getId(), vdc.getId(), vApp.getId(), GetVMOptions.Builder.withPowerState()));
                }
            }
        }
        return builder.build();
    }

    @Override
    public Iterable<Network> listLocations() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Resource org1 : this.client.listOrgs()) {
            Org org = this.client.getBrowsingClient().getOrg(org1.getId());
            for (Link vdc : org.getVDCs()) {
                VDC VDC2 = this.client.getBrowsingClient().getVDCInOrg(org.getId(), vdc.getId());
                if (this.email != null && VDC2.getDescription().indexOf(this.email) != -1) continue;
                for (Resource network : VDC2.getAvailableNetworks()) {
                    builder.add(this.client.getBrowsingClient().getNetworkInVDC(org.getId(), vdc.getId(), network.getId()));
                }
            }
        }
        return builder.build();
    }

    @Override
    public VM getNode(String id) {
        return this.client.getBrowsingClient().getVM(URI.create(Preconditions.checkNotNull(id, "id")), GetVMOptions.Builder.withPowerState());
    }

    @Override
    public void destroyNode(String id) {
        this.taskTester.apply(this.client.getVMClient().removeVM(URI.create(Preconditions.checkNotNull(id, "id"))).getId());
    }

    @Override
    public void rebootNode(String id) {
        this.suspendNode(id);
        this.resumeNode(id);
    }

    @Override
    public void resumeNode(String id) {
        this.taskTester.apply(this.client.getServiceManagementClient().powerOnVM(URI.create(Preconditions.checkNotNull(id, "id"))).getId());
    }

    @Override
    public void suspendNode(String id) {
        this.taskTester.apply(this.client.getServiceManagementClient().powerOffVM(URI.create(Preconditions.checkNotNull(id, "id"))).getId());
    }
}

