/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.compute.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;

@Singleton
public class FirstNetwork
implements Supplier<Location> {
    private final Supplier<Set<? extends Location>> locationsSupplier;
    private final IsNetwork isNetwork;

    @Inject
    FirstNetwork(@Memoized Supplier<Set<? extends Location>> locationsSupplier, IsNetwork isNetwork) {
        this.locationsSupplier = Preconditions.checkNotNull(locationsSupplier, "locationsSupplierSupplier");
        this.isNetwork = Preconditions.checkNotNull(isNetwork, "isNetwork");
    }

    @Override
    public Location get() {
        return Iterables.find((Iterable)this.locationsSupplier.get(), this.isNetwork);
    }

    @Singleton
    public static final class IsNetwork
    implements Predicate<Location> {
        @Override
        public boolean apply(Location input) {
            return input.getScope() == LocationScope.NETWORK;
        }

        public String toString() {
            return "isNetwork()";
        }
    }
}

