/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import org.jclouds.ovf.Section;

public class NetworkConnectionSection
extends Section<NetworkConnectionSection> {
    private final String network;
    private final String ipAddress;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return NetworkConnectionSection.builder().fromNetworkConectionSection(this);
    }

    public NetworkConnectionSection(String info, String network, String ipAddress) {
        super(info);
        this.network = network;
        this.ipAddress = ipAddress;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkConnectionSection other = (NetworkConnectionSection)obj;
        return !(this.network == null ? other.network != null : !this.network.equals(other.network));
    }

    @Override
    public String toString() {
        return String.format("[info=%s, network=%s, ipAddress=%s]", this.info, this.network, this.ipAddress);
    }

    public static class Builder
    extends Section.Builder<NetworkConnectionSection> {
        private String network;
        private String ipAddress;

        public Builder network(String network) {
            this.network = network;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public NetworkConnectionSection build() {
            return new NetworkConnectionSection(this.info, this.network, this.ipAddress);
        }

        public Builder fromNetworkConectionSection(NetworkConnectionSection in) {
            return ((Builder)this.fromSection((Section)in)).network(in.getNetwork()).ipAddress(in.getIpAddress());
        }

        public Builder fromSection(Section<NetworkConnectionSection> in) {
            return (Builder)Builder.class.cast(super.fromSection(in));
        }

        public Builder info(String info) {
            return (Builder)Builder.class.cast(super.info(info));
        }
    }
}

