/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import java.net.URI;
import org.jclouds.savvis.vpdc.domain.Resource;

public class ResourceImpl
implements Resource {
    protected final String id;
    protected final String name;
    protected final String type;
    protected final URI href;

    public static Builder builder() {
        return new Builder();
    }

    public ResourceImpl(String id, String name, String type, URI href) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.href = href;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public URI getHref() {
        return this.href;
    }

    @Override
    public int compareTo(Resource that) {
        return this == that ? 0 : this.getHref().compareTo(that.getHref());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceImpl other = (ResourceImpl)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public Builder toBuilder() {
        return Builder.fromResource(this);
    }

    public String toString() {
        return "[id=" + this.id + ", href=" + this.href + ", name=" + this.name + ", type=" + this.type + "]";
    }

    public static class Builder {
        protected String id;
        protected String name;
        protected String type;
        protected URI href;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder href(URI href) {
            this.href = href;
            return this;
        }

        public ResourceImpl build() {
            return new ResourceImpl(this.id, this.name, this.type, this.href);
        }

        public static Builder fromResource(ResourceImpl in) {
            return new Builder().id(in.getId()).name(in.getName()).type(in.getType()).href(in.getHref());
        }
    }
}

