/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.domain.ResourceImpl;
import org.jclouds.savvis.vpdc.domain.TaskError;

public class Task
extends ResourceImpl {
    private final Status status;
    private final Date startTime;
    private final Date endTime;
    private final Resource owner;
    private final Resource result;
    private final TaskError error;

    public static Builder builder() {
        return new Builder();
    }

    public Task(String id, String name, String type, URI href, Status status, Date startTime, Date endTime, Resource result, Resource owner, TaskError error) {
        super(id, name, type, href);
        this.status = status;
        this.startTime = startTime;
        this.endTime = endTime;
        this.owner = owner;
        this.result = result;
        this.error = error;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    @Nullable
    public Date getEndTime() {
        return this.endTime;
    }

    @Nullable
    public Resource getOwner() {
        return this.owner;
    }

    @Nullable
    public Resource getResult() {
        return this.result;
    }

    @Nullable
    public TaskError getError() {
        return this.error;
    }

    @Override
    public Builder toBuilder() {
        return Builder.fromTask(this);
    }

    @Override
    public String toString() {
        return "[id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", href=" + this.href + ", status=" + (Object)((Object)this.status) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", owner=" + this.owner + ", result=" + this.result + ", error=" + this.error + "]";
    }

    public static enum Status {
        SUCCESS,
        RUNNING,
        QUEUED,
        ERROR,
        NONE,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(Preconditions.checkNotNull(status, "status").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder
    extends ResourceImpl.Builder {
        private Status status;
        private Date startTime;
        private Date endTime;
        private Resource owner;
        private Resource result;
        private TaskError error;

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder owner(Resource owner) {
            this.owner = owner;
            return this;
        }

        public Builder result(Resource result) {
            this.result = result;
            return this;
        }

        public Builder error(TaskError error) {
            this.error = error;
            return this;
        }

        @Override
        public Builder id(String id) {
            return (Builder)Builder.class.cast(super.id(id));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder type(String type) {
            return (Builder)Builder.class.cast(super.type(type));
        }

        @Override
        public Builder href(URI href) {
            return (Builder)Builder.class.cast(super.href(href));
        }

        @Override
        public Task build() {
            return new Task(this.id, this.name, this.type, this.href, this.status, this.startTime, this.endTime, this.owner, this.result, this.error);
        }

        public static Builder fromTask(Task in) {
            return new Builder().id(in.getId()).name(in.getName()).type(in.getType()).href(in.getHref()).status(in.getStatus()).startTime(in.getStartTime()).endTime(in.getEndTime()).owner(in.getOwner()).error(in.getError()).result(in.getResult());
        }
    }
}

