/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.domain.ResourceImpl;

public class VDC
extends ResourceImpl {
    @Nullable
    private final String description;
    private final Status status;
    private final Set<Resource> resourceEntities;
    private final Set<Resource> availableNetworks;

    public static Builder builder() {
        return new Builder();
    }

    public VDC(String id, String name, String type, URI href, @Nullable String description, Status status, Set<Resource> resourceEntities, Set<Resource> availableNetworks) {
        super(id, name, type, href);
        this.description = description;
        this.status = Preconditions.checkNotNull(status, "status");
        this.resourceEntities = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(resourceEntities, "resourceEntities"));
        this.availableNetworks = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(availableNetworks, "availableNetworks"));
    }

    public String getDescription() {
        return this.description;
    }

    public Status getStatus() {
        return this.status;
    }

    public Set<Resource> getResourceEntities() {
        return this.resourceEntities;
    }

    public Set<Resource> getAvailableNetworks() {
        return this.availableNetworks;
    }

    @Override
    public Builder toBuilder() {
        return Builder.fromVDC(this);
    }

    @Override
    public String toString() {
        return "[id=" + this.id + ", href=" + this.href + ", name=" + this.name + ", type=" + this.type + ", description=" + this.description + ", status=" + (Object)((Object)this.status) + ", resourceEntities=" + this.resourceEntities + ", availableNetworks=" + this.availableNetworks + "]";
    }

    public static enum Status {
        DEPLOYED,
        DESIGNING,
        SAVED,
        INQUEUE,
        PROVISIONING,
        PARTIALLY_DEPLOYED,
        FAILED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(status, "status")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder
    extends ResourceImpl.Builder {
        private String description;
        private Status status;
        private Set<Resource> resourceEntities = Sets.newLinkedHashSet();
        private Set<Resource> availableNetworks = Sets.newLinkedHashSet();

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder resourceEntity(Resource resourceEntity) {
            this.resourceEntities.add(Preconditions.checkNotNull(resourceEntity, "resourceEntity"));
            return this;
        }

        public Builder resourceEntities(Set<Resource> resourceEntities) {
            this.resourceEntities.addAll((Collection<Resource>)Preconditions.checkNotNull(resourceEntities, "resourceEntities"));
            return this;
        }

        public Builder availableNetwork(Resource availableNetwork) {
            this.availableNetworks.add(Preconditions.checkNotNull(availableNetwork, "availableNetwork"));
            return this;
        }

        public Builder availableNetworks(Set<Resource> availableNetworks) {
            this.availableNetworks.addAll((Collection<Resource>)Preconditions.checkNotNull(availableNetworks, "availableNetworks"));
            return this;
        }

        @Override
        public VDC build() {
            return new VDC(this.id, this.name, this.type, this.href, this.description, this.status, this.resourceEntities, this.availableNetworks);
        }

        public static Builder fromVDC(VDC in) {
            return new Builder().id(in.getId()).name(in.getName()).type(in.getType()).href(in.getHref()).status(in.getStatus()).description(in.getDescription()).availableNetworks(in.getAvailableNetworks()).resourceEntities(in.getResourceEntities());
        }

        @Override
        public Builder id(String id) {
            return (Builder)Builder.class.cast(super.id(id));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder type(String type) {
            return (Builder)Builder.class.cast(super.type(type));
        }

        @Override
        public Builder href(URI href) {
            return (Builder)Builder.class.cast(super.href(href));
        }
    }
}

