/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Set;
import org.jclouds.ovf.NetworkSection;
import org.jclouds.ovf.OperatingSystemSection;
import org.jclouds.ovf.ProductSection;
import org.jclouds.ovf.Section;
import org.jclouds.ovf.VirtualHardwareSection;
import org.jclouds.ovf.internal.BaseVirtualSystem;
import org.jclouds.savvis.vpdc.domain.NetworkConfigSection;
import org.jclouds.savvis.vpdc.domain.NetworkConnectionSection;
import org.jclouds.savvis.vpdc.domain.Resource;

public class VM
extends BaseVirtualSystem<VM>
implements Resource {
    protected final String type;
    protected final URI href;
    protected final Status status;
    protected final NetworkSection networkSection;
    protected final Set<NetworkConfigSection> networkConfigSections;
    protected final Set<NetworkConnectionSection> networkConnectionSections;

    public static Builder builder() {
        return new Builder();
    }

    public VM(String id, String info, String name, OperatingSystemSection operatingSystem, Iterable<? extends VirtualHardwareSection> virtualHardwareSections, Iterable<? extends ProductSection> productSections, Multimap<String, Section> additionalSections, String type, URI href, Status status, NetworkSection networkSection, Iterable<NetworkConfigSection> networkConfigSections, Iterable<NetworkConnectionSection> networkConnectionSections) {
        super(id, info, name, operatingSystem, virtualHardwareSections, productSections, additionalSections);
        this.type = type;
        this.href = href;
        this.status = status;
        this.networkSection = networkSection;
        this.networkConfigSections = ImmutableSet.copyOf(Preconditions.checkNotNull(networkConfigSections, "networkConfigSections"));
        this.networkConnectionSections = ImmutableSet.copyOf(Preconditions.checkNotNull(networkConnectionSections, "networkConnectionSections"));
    }

    public Status getStatus() {
        return this.status;
    }

    public NetworkSection getNetworkSection() {
        return this.networkSection;
    }

    public Set<NetworkConfigSection> getNetworkConfigSections() {
        return this.networkConfigSections;
    }

    public Set<NetworkConnectionSection> getNetworkConnectionSections() {
        return this.networkConnectionSections;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public URI getHref() {
        return this.href;
    }

    @Override
    public String toString() {
        return String.format("[id=%s, name=%s, info=%s, href=%s,status=%s, type=%s, virtualHardwareSections=%s, operatingSystem=%s, productSections=%s, networkSection=%s,  networkConfigSections=%s, networkConnectionSections=%s, additionalSections=%s]", new Object[]{this.id, this.name, this.info, this.href, this.status, this.type, this.virtualHardwareSections, this.operatingSystem, this.productSections, this.networkSection, this.networkConfigSections, this.networkConnectionSections, this.additionalSections});
    }

    @Override
    public int compareTo(Resource that) {
        return this == that ? 0 : this.getHref().compareTo(that.getHref());
    }

    @Override
    public Builder toBuilder() {
        return VM.builder().fromVM(this);
    }

    public static class Builder
    extends BaseVirtualSystem.Builder<VM> {
        protected String type;
        protected URI href;
        protected Status status;
        protected NetworkSection networkSection;
        protected Set<NetworkConfigSection> networkConfigSections = Sets.newLinkedHashSet();
        protected Set<NetworkConnectionSection> networkConnectionSections = Sets.newLinkedHashSet();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder href(URI href) {
            this.href = href;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder networkSection(NetworkSection networkSection) {
            this.networkSection = networkSection;
            return this;
        }

        public Builder networkConfigSection(NetworkConfigSection networkConfigSection) {
            this.networkConfigSections.add(Preconditions.checkNotNull(networkConfigSection, "networkConfigSection"));
            return this;
        }

        public Builder networkConfigSections(Iterable<NetworkConfigSection> networkConfigSections) {
            this.networkConfigSections = ImmutableSet.copyOf(Preconditions.checkNotNull(networkConfigSections, "networkConfigSections"));
            return this;
        }

        public Builder networkConnectionSection(NetworkConnectionSection networkConnectionSection) {
            this.networkConnectionSections.add(Preconditions.checkNotNull(networkConnectionSection, "networkConnectionSection"));
            return this;
        }

        public Builder networkConnectionSections(Iterable<NetworkConnectionSection> networkConnectionSections) {
            this.networkConnectionSections = ImmutableSet.copyOf(Preconditions.checkNotNull(networkConnectionSections, "networkConnectionSections"));
            return this;
        }

        @Override
        public VM build() {
            return new VM(this.id, this.info, this.name, this.operatingSystem, this.virtualHardwareSections, this.productSections, this.additionalSections, this.type, this.href, this.status, this.networkSection, this.networkConfigSections, this.networkConnectionSections);
        }

        public Builder fromVM(VM in) {
            return ((Builder)this.fromVirtualSystem((BaseVirtualSystem)in)).type(in.getType()).href(in.getHref()).status(in.getStatus()).networkSection(in.getNetworkSection()).networkConfigSections(in.getNetworkConfigSections()).networkConnectionSections(in.getNetworkConnectionSections());
        }

        public Builder additionalSection(String name, Section additionalSection) {
            return (Builder)Builder.class.cast(super.additionalSection(name, additionalSection));
        }

        public Builder additionalSections(Multimap<String, Section> additionalSections) {
            return (Builder)Builder.class.cast(super.additionalSections(additionalSections));
        }

        public Builder fromSection(Section<VM> in) {
            return (Builder)Builder.class.cast(super.fromSection((Section)in));
        }

        public Builder fromVirtualSystem(BaseVirtualSystem<VM> in) {
            return (Builder)Builder.class.cast(super.fromVirtualSystem(in));
        }

        public Builder virtualHardwareSection(VirtualHardwareSection virtualHardwareSection) {
            return (Builder)Builder.class.cast(super.virtualHardwareSection(virtualHardwareSection));
        }

        public Builder virtualHardwareSections(Iterable<? extends VirtualHardwareSection> virtualHardwareSections) {
            return (Builder)Builder.class.cast(super.virtualHardwareSections(virtualHardwareSections));
        }

        @Override
        public Builder info(String info) {
            return (Builder)Builder.class.cast(super.info(info));
        }

        public Builder operatingSystemSection(OperatingSystemSection operatingSystem) {
            return (Builder)Builder.class.cast(super.operatingSystemSection(operatingSystem));
        }

        public Builder productSection(ProductSection productSection) {
            return (Builder)Builder.class.cast(super.productSection(productSection));
        }

        public Builder productSections(Iterable<? extends ProductSection> productSections) {
            return (Builder)Builder.class.cast(super.productSections(productSections));
        }
    }

    public static enum Status {
        UNRESOLVED,
        RESOLVED,
        OFF,
        SUSPENDED,
        ON,
        UNKNOWN,
        UNRECOGNIZED;


        public String value() {
            switch (this) {
                case UNRESOLVED: {
                    return "0";
                }
                case RESOLVED: {
                    return "1";
                }
                case OFF: {
                    return "2";
                }
                case SUSPENDED: {
                    return "3";
                }
                case ON: {
                    return "4";
                }
                case UNKNOWN: {
                    return "5";
                }
            }
            return "UNRECOGNIZED";
        }

        public static Status fromValue(String status) {
            try {
                return Status.fromValue(Integer.parseInt(Preconditions.checkNotNull(status, "status")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        public static Status fromValue(int v) {
            switch (v) {
                case 0: {
                    return UNRESOLVED;
                }
                case 1: {
                    return RESOLVED;
                }
                case 2: {
                    return OFF;
                }
                case 3: {
                    return SUSPENDED;
                }
                case 4: {
                    return ON;
                }
                case 5: {
                    return UNKNOWN;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

