/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.compute.domain.CIMOperatingSystem;

public class VMSpec {
    private final String name;
    private final String networkTierName;
    private final CIMOperatingSystem operatingSystem;
    private final int processorCount;
    private final int memoryInGig;
    private final String bootDeviceName;
    private final int bootDriveSize;
    private final Map<String, Integer> dataDriveDeviceNameToSizeInGig;

    public static Builder builder() {
        return new Builder();
    }

    static void checkProcessorCount(int processorCount) {
        Preconditions.checkArgument(processorCount > 0, "processorCount must be positive and an increment of 0.5");
        Preconditions.checkArgument((double)processorCount % 0.5 == 0.0, "processorCount must be an increment of 0.5");
    }

    protected VMSpec(String name, String networkTierName, CIMOperatingSystem operatingSystem, int processorCount, int memoryInGig, String bootDeviceName, int bootDriveSize, Map<String, Integer> dataDriveDeviceNameToSizeInGig) {
        this.name = name;
        this.networkTierName = networkTierName;
        this.operatingSystem = Preconditions.checkNotNull(operatingSystem, "operatingSystem not specified");
        VMSpec.checkProcessorCount(processorCount);
        this.processorCount = processorCount;
        Preconditions.checkArgument(memoryInGig > 0, "memoryInGig must be positive");
        this.memoryInGig = memoryInGig;
        this.bootDeviceName = Preconditions.checkNotNull(bootDeviceName, "bootDeviceName name not specified");
        Preconditions.checkArgument(bootDriveSize > 0, "bootDriveSize must be positive");
        this.bootDriveSize = bootDriveSize;
        this.dataDriveDeviceNameToSizeInGig = ImmutableMap.copyOf(Preconditions.checkNotNull(dataDriveDeviceNameToSizeInGig, "dataDriveDeviceNameToSizeInGig"));
    }

    public String getName() {
        return this.name;
    }

    public String getNetworkTierName() {
        return this.networkTierName;
    }

    public CIMOperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public int getProcessorCount() {
        return this.processorCount;
    }

    public int getMemoryInGig() {
        return this.memoryInGig;
    }

    public Builder toBuilder() {
        return Builder.fromVMSpec(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bootDeviceName == null ? 0 : this.bootDeviceName.hashCode());
        result = 31 * result + this.bootDriveSize;
        result = 31 * result + (this.dataDriveDeviceNameToSizeInGig == null ? 0 : ((Object)this.dataDriveDeviceNameToSizeInGig).hashCode());
        result = 31 * result + this.memoryInGig;
        result = 31 * result + (this.operatingSystem == null ? 0 : this.operatingSystem.hashCode());
        result = 31 * result + this.processorCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VMSpec other = (VMSpec)obj;
        if (this.bootDeviceName == null ? other.bootDeviceName != null : !this.bootDeviceName.equals(other.bootDeviceName)) {
            return false;
        }
        if (this.bootDriveSize != other.bootDriveSize) {
            return false;
        }
        if (this.dataDriveDeviceNameToSizeInGig == null ? other.dataDriveDeviceNameToSizeInGig != null : !((Object)this.dataDriveDeviceNameToSizeInGig).equals(other.dataDriveDeviceNameToSizeInGig)) {
            return false;
        }
        if (this.memoryInGig != other.memoryInGig) {
            return false;
        }
        if (this.operatingSystem == null ? other.operatingSystem != null : !this.operatingSystem.equals(other.operatingSystem)) {
            return false;
        }
        return this.processorCount == other.processorCount;
    }

    public String getBootDeviceName() {
        return this.bootDeviceName;
    }

    public int getBootDiskSize() {
        return this.bootDriveSize;
    }

    public Map<String, Integer> getDataDiskDeviceNameToSizeInGig() {
        return this.dataDriveDeviceNameToSizeInGig;
    }

    public String toString() {
        return "[name= " + this.name + ", operatingSystem=" + this.operatingSystem + ", processorCount=" + this.processorCount + ", memoryInGig=" + this.memoryInGig + ", networkTierName=" + this.networkTierName + ", bootDeviceName=" + this.bootDeviceName + ", bootDriveSize=" + this.bootDriveSize + ", dataDriveDeviceNameToSizeInGig=" + this.dataDriveDeviceNameToSizeInGig + "]";
    }

    public static class Builder {
        private String name;
        private String networkTierName;
        private CIMOperatingSystem operatingSystem;
        private int processorCount = 1;
        private int memoryInGig = 1;
        private String bootDeviceName = "/";
        private int bootDriveSize = 25;
        private Map<String, Integer> dataDriveDeviceNameToSizeInGig = Maps.newLinkedHashMap();

        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        public Builder networkTierName(String networkTierName) {
            this.networkTierName = Preconditions.checkNotNull(networkTierName, "networkTierName");
            return this;
        }

        public Builder operatingSystem(CIMOperatingSystem operatingSystem) {
            this.operatingSystem = Preconditions.checkNotNull(operatingSystem, "operatingSystem");
            return this;
        }

        public Builder memoryInGig(int memoryInGig) {
            Preconditions.checkArgument(memoryInGig > 0, "memoryInGig must be positive");
            this.memoryInGig = memoryInGig;
            return this;
        }

        public Builder processorCount(int processorCount) {
            VMSpec.checkProcessorCount(processorCount);
            this.processorCount = processorCount;
            return this;
        }

        public Builder bootDeviceName(String bootDeviceName) {
            this.bootDeviceName = Preconditions.checkNotNull(bootDeviceName, "bootDeviceName");
            return this;
        }

        public Builder bootDiskSize(int bootDriveSize) {
            Preconditions.checkArgument(bootDriveSize > 0, "bootDriveSize must be positive");
            this.bootDriveSize = bootDriveSize;
            return this;
        }

        public Builder addDataDrive(String dataDriveDeviceName, int sizeInGig) {
            Preconditions.checkArgument(sizeInGig > 0, "sizeInGig must be positive");
            this.dataDriveDeviceNameToSizeInGig.put(Preconditions.checkNotNull(dataDriveDeviceName, "dataDriveDeviceName"), sizeInGig);
            return this;
        }

        public Builder addDataDrives(Map<String, Integer> dataDriveDeviceNameToSizeInGig) {
            this.dataDriveDeviceNameToSizeInGig = ImmutableMap.copyOf(Preconditions.checkNotNull(dataDriveDeviceNameToSizeInGig, "dataDriveDeviceNameToSizeInGig"));
            return this;
        }

        public VMSpec build() {
            return new VMSpec(this.name, this.networkTierName, this.operatingSystem, this.processorCount, this.memoryInGig, this.bootDeviceName, this.bootDriveSize, this.dataDriveDeviceNameToSizeInGig);
        }

        public static Builder fromVMSpec(VMSpec in) {
            return new Builder().operatingSystem(in.getOperatingSystem()).memoryInGig(in.getMemoryInGig()).bootDeviceName(in.getBootDeviceName()).bootDiskSize(in.getBootDiskSize()).addDataDrives(in.getDataDiskDeviceNameToSizeInGig()).processorCount(in.getProcessorCount());
        }
    }
}

