/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.savvis.vpdc.binders.BindCaptureVAppTemplateToXmlPayload;
import org.jclouds.savvis.vpdc.binders.BindCloneVMToXmlPayload;
import org.jclouds.savvis.vpdc.binders.BindVMSpecToXmlPayload;
import org.jclouds.savvis.vpdc.binders.BindVMSpecsToXmlPayload;
import org.jclouds.savvis.vpdc.domain.Task;
import org.jclouds.savvis.vpdc.domain.VMSpec;
import org.jclouds.savvis.vpdc.filters.SetVCloudTokenCookie;
import org.jclouds.savvis.vpdc.functions.DefaultOrgIfNull;
import org.jclouds.savvis.vpdc.xml.TaskHandler;
import org.jclouds.savvis.vpdc.xml.TasksListHandler;

@RequestFilters(value={SetVCloudTokenCookie.class})
public interface VMAsyncClient {
    @GET
    @XMLResponseParser(value=TaskHandler.class)
    @Path(value="v{jclouds.api-version}/org/{billingSiteId}/vdc/{vpdcId}/vApp/")
    @MapBinder(value=BindVMSpecToXmlPayload.class)
    public ListenableFuture<Task> addVMIntoVDC(@PathParam(value="billingSiteId") @Nullable @ParamParser(value=DefaultOrgIfNull.class) String var1, @PathParam(value="vpdcId") String var2, VMSpec var3);

    @GET
    @XMLResponseParser(value=TaskHandler.class)
    @Path(value="vApp/")
    @MapBinder(value=BindVMSpecToXmlPayload.class)
    public ListenableFuture<Task> addVMIntoVDC(@EndpointParam URI var1, VMSpec var2);

    @GET
    @XMLResponseParser(value=TasksListHandler.class)
    @Path(value="v{jclouds.api-version}/org/{billingSiteId}/vdc/{vpdcId}/vApp/")
    @MapBinder(value=BindVMSpecsToXmlPayload.class)
    public ListenableFuture<Set<Task>> addMultipleVMsIntoVDC(@PathParam(value="billingSiteId") @Nullable @ParamParser(value=DefaultOrgIfNull.class) String var1, @PathParam(value="vpdcId") String var2, Iterable<VMSpec> var3);

    @GET
    @XMLResponseParser(value=TasksListHandler.class)
    @Path(value="vApp/")
    @MapBinder(value=BindVMSpecsToXmlPayload.class)
    public ListenableFuture<Set<Task>> addMultipleVMsIntoVDC(@EndpointParam URI var1, Iterable<VMSpec> var2);

    @POST
    @XMLResponseParser(value=TaskHandler.class)
    @Path(value="v{jclouds.api-version}/org/{billingSiteId}/vdc/{vpdcId}/action/captureVApp")
    @MapBinder(value=BindCaptureVAppTemplateToXmlPayload.class)
    public ListenableFuture<Task> captureVApp(@PathParam(value="billingSiteId") @Nullable @ParamParser(value=DefaultOrgIfNull.class) String var1, @PathParam(value="vpdcId") String var2, URI var3);

    @POST
    @XMLResponseParser(value=TaskHandler.class)
    @Path(value="action/cloneVApp")
    @MapBinder(value=BindCloneVMToXmlPayload.class)
    public ListenableFuture<Task> cloneVApp(@EndpointParam URI var1, @PayloadParam(value="name") String var2, @PayloadParam(value="networkTierName") String var3);

    @DELETE
    @XMLResponseParser(value=TaskHandler.class)
    @Path(value="v{jclouds.api-version}/org/{billingSiteId}/vdc/{vpdcId}/vApp/{vAppId}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Task> removeVMFromVDC(@PathParam(value="billingSiteId") @Nullable @ParamParser(value=DefaultOrgIfNull.class) String var1, @PathParam(value="vpdcId") String var2, @PathParam(value="vAppId") String var3);

    @DELETE
    @XMLResponseParser(value=TaskHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Task> removeVM(@EndpointParam URI var1);

    @POST
    @XMLResponseParser(value=TaskHandler.class)
    @Path(value="action/powerOff")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Task> powerOffVM(@EndpointParam URI var1);

    @POST
    @XMLResponseParser(value=TaskHandler.class)
    @Path(value="action/powerOn")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Task> powerOnVM(@EndpointParam URI var1);
}

