/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.domain.internal.VCloudSession;
import org.jclouds.savvis.vpdc.internal.VCloudToken;
import org.jclouds.savvis.vpdc.xml.OrgListHandler;

@Singleton
public class ParseLoginResponseFromHeaders
implements Function<HttpResponse, VCloudSession> {
    static final Pattern pattern = Pattern.compile("vcloud-token=([^;]+);.*");
    private final ParseSax.Factory factory;
    private final Provider<OrgListHandler> orgHandlerProvider;

    @Inject
    private ParseLoginResponseFromHeaders(ParseSax.Factory factory, Provider<OrgListHandler> orgHandlerProvider) {
        this.factory = factory;
        this.orgHandlerProvider = orgHandlerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VCloudSession apply(HttpResponse from) {
        String cookieHeader = Preconditions.checkNotNull(from.getFirstHeaderOrNull("Set-Cookie"), "Set-Cookie");
        final Matcher matcher = pattern.matcher(cookieHeader);
        boolean matchFound = matcher.find();
        try {
            if (matchFound) {
                final Set org = (Set)this.factory.create(this.orgHandlerProvider.get()).parse(from.getPayload().getInput());
                VCloudSession vCloudSession = new VCloudSession(){

                    @Override
                    @VCloudToken
                    public String getVCloudToken() {
                        return matcher.group(1);
                    }

                    @Override
                    public Set<Resource> getOrgs() {
                        return org;
                    }
                };
                return vCloudSession;
            }
        }
        finally {
            HttpUtils.releasePayload(from);
        }
        throw new HttpResponseException("not found ", null, from);
    }
}

