/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import org.jclouds.http.functions.ParseSax;
import org.jclouds.savvis.vpdc.domain.FirewallRule;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FirewallRuleHandler
extends ParseSax.HandlerWithResult<FirewallRule> {
    protected StringBuilder currentText = new StringBuilder();
    private FirewallRule.Builder builder = FirewallRule.builder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FirewallRule getResult() {
        try {
            FirewallRule firewallRule = this.builder.build();
            return firewallRule;
        }
        finally {
            this.builder = FirewallRule.builder();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String current = SaxUtils.currentOrNull(this.currentText);
        if (current != null) {
            if (SaxUtils.equalsOrSuffix(qName, "Type")) {
                this.builder.firewallType(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "IsEnabled")) {
                this.builder.isEnabled(Boolean.parseBoolean(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "Source")) {
                this.builder.source(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Destination")) {
                this.builder.destination(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Port")) {
                this.builder.port(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Policy")) {
                this.builder.policy(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Description")) {
                this.builder.description(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Log")) {
                this.builder.isLogged(Boolean.parseBoolean(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "Tcp")) {
                this.builder.protocol("Tcp");
            } else if (qName.contains("Udp") || qName.contains("udp")) {
                this.builder.protocol("Udp");
            } else if (qName.contains("Icmp") || qName.contains("icmp") || qName.contains("Ping") || qName.contains("ping")) {
                this.builder.protocol("Icmp-ping");
            }
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

