/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.savvis.vpdc.domain.FirewallService;
import org.jclouds.savvis.vpdc.xml.FirewallRuleHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FirewallServiceHandler
extends ParseSax.HandlerWithResult<FirewallService> {
    protected StringBuilder currentText = new StringBuilder();
    private FirewallRuleHandler firewallRuleHandler;
    private FirewallService.Builder builder = FirewallService.builder();
    boolean inFirewallService;
    boolean inFirewallRule;

    @Inject
    public FirewallServiceHandler(FirewallRuleHandler firewallRuleHandler) {
        this.firewallRuleHandler = firewallRuleHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FirewallService getResult() {
        try {
            FirewallService firewallService = this.builder.build();
            return firewallService;
        }
        finally {
            this.builder = FirewallService.builder();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "FirewallService")) {
            this.inFirewallService = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "FirewallRule")) {
            this.inFirewallRule = true;
            this.firewallRuleHandler.startElement(uri, localName, qName, attrs);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String current;
        if (SaxUtils.equalsOrSuffix(qName, "FirewallService")) {
            this.inFirewallService = false;
        } else if (SaxUtils.equalsOrSuffix(qName, "FirewallRule")) {
            this.builder.firewallRule(this.firewallRuleHandler.getResult());
            this.inFirewallRule = false;
        } else if (SaxUtils.equalsOrSuffix(qName, "isEnabled") && this.inFirewallService && (current = SaxUtils.currentOrNull(this.currentText)) != null) {
            this.builder.isEnabled(Boolean.parseBoolean(current));
        }
        if (this.inFirewallRule) {
            this.firewallRuleHandler.endElement(uri, localName, qName);
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
        this.firewallRuleHandler.characters(ch, start, length);
    }
}

