/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.savvis.vpdc.domain.NetworkConfigSection;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class NetworkConfigSectionHandler
extends SectionHandler<NetworkConfigSection, NetworkConfigSection.Builder> {
    @Inject
    public NetworkConfigSectionHandler(Provider<NetworkConfigSection.Builder> builderProvider) {
        super(builderProvider);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "Section") && "vApp:NetworkConfigSectionType".equals(attributes.get("type"))) {
            ((NetworkConfigSection.Builder)this.builder).network(attributes.get("Network"));
            ((NetworkConfigSection.Builder)this.builder).netmask(attributes.get("Netmask"));
            ((NetworkConfigSection.Builder)this.builder).gateway(attributes.get("Gateway"));
        } else if (SaxUtils.equalsOrSuffix(qName, "NatRule")) {
            ((NetworkConfigSection.Builder)this.builder).internalToExternalNATRule(attributes.get("internalIP"), attributes.get("externalIP"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "FenceMode")) {
            ((NetworkConfigSection.Builder)this.builder).fenceMode(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Dhcp")) {
            ((NetworkConfigSection.Builder)this.builder).dhcp(new Boolean(SaxUtils.currentOrNull(this.currentText)));
        }
        super.endElement(uri, localName, qName);
    }
}

