/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.savvis.vpdc.domain.NetworkConnectionSection;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class NetworkConnectionSectionHandler
extends SectionHandler<NetworkConnectionSection, NetworkConnectionSection.Builder> {
    @Inject
    public NetworkConnectionSectionHandler(Provider<NetworkConnectionSection.Builder> builderProvider) {
        super(builderProvider);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "Section") && "vApp:NetworkConnectionType".equals(attributes.get("type"))) {
            ((NetworkConnectionSection.Builder)this.builder).network(attributes.get("Network"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "IpAddress")) {
            ((NetworkConnectionSection.Builder)this.builder).ipAddress(SaxUtils.currentOrNull(this.currentText));
        }
        super.endElement(uri, localName, qName);
    }
}

