/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.savvis.vpdc.domain.Network;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.util.Utils;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NetworkHandler
extends ParseSax.HandlerWithResult<Network> {
    protected StringBuilder currentText = new StringBuilder();
    protected Network.Builder builder = Network.builder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Network getResult() {
        try {
            Network network = this.builder.build();
            return network;
        }
        finally {
            this.builder = Network.builder();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = Utils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "Network")) {
            if (!attributes.containsKey("href") && this.getRequest() != null) {
                attributes = ImmutableMap.builder().putAll(attributes).put("href", this.getRequest().getEndpoint().toASCIIString()).build();
            }
            Resource org = Utils.newResource(attributes);
            this.builder.name(org.getName()).type(org.getType()).id(org.getId()).href(org.getHref());
        } else if (SaxUtils.equalsOrSuffix(qName, "NatRule")) {
            this.builder.internalToExternalNATRule(attributes.get("internalIP"), attributes.get("externalIP"));
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "Gateway")) {
            this.builder.gateway(Utils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Netmask")) {
            this.builder.netmask(Utils.currentOrNull(this.currentText));
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

