/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.ovf.Network;
import org.jclouds.ovf.NetworkSection;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class NetworkSectionHandler
extends SectionHandler<NetworkSection, NetworkSection.Builder> {
    protected Network.Builder networkBuilder = Network.builder();

    @Inject
    public NetworkSectionHandler(Provider<NetworkSection.Builder> builderProvider) {
        super(builderProvider);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "Network")) {
            this.networkBuilder.name(attributes.get("name"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "Info")) {
            ((NetworkSection.Builder)this.builder).info(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Description")) {
            this.networkBuilder.description(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Network")) {
            try {
                ((NetworkSection.Builder)this.builder).network(this.networkBuilder.build());
            }
            finally {
                this.networkBuilder = Network.builder();
            }
        }
        super.endElement(uri, localName, qName);
    }
}

