/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.savvis.vpdc.domain.Task;
import org.jclouds.savvis.vpdc.xml.TaskHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TasksListHandler
extends ParseSax.HandlerWithResult<Set<Task>> {
    private ImmutableSet.Builder<Task> tasks = ImmutableSet.builder();
    private final TaskHandler taskHandler;

    @Inject
    public TasksListHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Task> getResult() {
        try {
            ImmutableCollection immutableCollection = this.tasks.build();
            return immutableCollection;
        }
        finally {
            this.tasks = ImmutableSet.builder();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.taskHandler.startElement(uri, localName, qName, attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.taskHandler.endElement(uri, localName, qName);
        if (SaxUtils.equalsOrSuffix(qName, "Task")) {
            this.tasks.add((Object)this.taskHandler.getResult());
        }
    }
}

