/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.domain.VDC;
import org.jclouds.savvis.vpdc.util.Utils;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VDCHandler
extends ParseSax.HandlerWithResult<VDC> {
    protected StringBuilder currentText = new StringBuilder();
    protected VDC.Builder builder = VDC.builder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VDC getResult() {
        try {
            VDC vDC = this.builder.build();
            return vDC;
        }
        finally {
            this.builder = VDC.builder();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = Utils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "Vdc")) {
            if (!attributes.containsKey("href") && this.getRequest() != null) {
                attributes = ImmutableMap.builder().putAll(attributes).put("href", this.getRequest().getEndpoint().toASCIIString()).build();
            }
            Resource vDC = Utils.newResource(attributes);
            this.builder.name(vDC.getName()).type(vDC.getType()).id(vDC.getId()).href(vDC.getHref());
        } else if (SaxUtils.equalsOrSuffix(qName, "Network")) {
            this.builder.availableNetwork(Utils.newResource(attributes));
        } else if (SaxUtils.equalsOrSuffix(qName, "ResourceEntity")) {
            this.builder.resourceEntity(Utils.newResource(attributes));
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "Description")) {
            this.builder.description(Utils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "OfferingTag")) {
            this.builder.status(VDC.Status.fromValue(Utils.currentOrNull(this.currentText)));
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

