/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.scriptbuilder.ScriptBuilder;
import org.jclouds.scriptbuilder.domain.CreateRunScript;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

public class InitBuilder
extends ScriptBuilder {
    private final String instanceName;
    private final String instanceHome;
    private final String logDir;
    private final StatementList initStatement;
    private final CreateRunScript createRunScript;

    public InitBuilder(String instanceName, String instanceHome, String logDir, Map<String, String> variables, Iterable<Statement> statements) {
        this(instanceName, instanceHome, logDir, variables, ImmutableSet.of(), statements);
    }

    public InitBuilder(String instanceName, String instanceHome, String logDir, Map<String, String> variables, Iterable<Statement> initStatements, Iterable<Statement> statements) {
        ImmutableMap<String, String> defaultVariables = ImmutableMap.of("instanceName", instanceName, "instanceHome", instanceHome, "logDir", logDir);
        this.initStatement = new StatementList(initStatements);
        this.createRunScript = Statements.createRunScript(instanceName, Iterables.concat(variables.keySet(), defaultVariables.keySet()), "{varl}INSTANCE_HOME{varr}", statements);
        this.instanceName = Preconditions.checkNotNull(instanceName, "instanceName");
        this.instanceHome = Preconditions.checkNotNull(instanceHome, "instanceHome");
        this.logDir = Preconditions.checkNotNull(logDir, "logDir");
        this.addEnvironmentVariableScope("default", defaultVariables).addEnvironmentVariableScope(instanceName, variables).addStatement(Statements.switchArg(1, new ImmutableMap.Builder<String, Statement>().put("init", Statements.newStatementList(Statements.call("default", new String[0]), Statements.call(instanceName, new String[0]), this.initStatement, this.createRunScript)).put("status", Statements.newStatementList(Statements.call("default", new String[0]), Statements.findPid("{varl}INSTANCE_NAME{varr}"), Statements.interpret("echo [{varl}FOUND_PID{varr}]{lf}"))).put("stop", Statements.newStatementList(Statements.call("default", new String[0]), Statements.findPid("{varl}INSTANCE_NAME{varr}"), Statements.kill())).put("start", Statements.newStatementList(Statements.call("default", new String[0]), Statements.forget("{varl}INSTANCE_NAME{varr}", "{varl}INSTANCE_HOME{varr}{fs}{varl}INSTANCE_NAME{varr}.{sh}", "{varl}LOG_DIR{varr}"))).put("tail", Statements.newStatementList(Statements.call("default", new String[0]), Statements.interpret("tail {varl}LOG_DIR{varr}{fs}stdout.log{lf}"))).put("tailerr", Statements.newStatementList(Statements.call("default", new String[0]), Statements.interpret("tail {varl}LOG_DIR{varr}{fs}stderr.log{lf}"))).put("run", Statements.newStatementList(Statements.call("default", new String[0]), Statements.interpret("{varl}INSTANCE_HOME{varr}{fs}{varl}INSTANCE_NAME{varr}.{sh}{lf}"))).build()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instanceHome == null ? 0 : this.instanceHome.hashCode());
        result = 31 * result + (this.instanceName == null ? 0 : this.instanceName.hashCode());
        result = 31 * result + (this.logDir == null ? 0 : this.logDir.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitBuilder other = (InitBuilder)obj;
        if (this.instanceHome == null ? other.instanceHome != null : !this.instanceHome.equals(other.instanceHome)) {
            return false;
        }
        if (this.instanceName == null ? other.instanceName != null : !this.instanceName.equals(other.instanceName)) {
            return false;
        }
        return !(this.logDir == null ? other.logDir != null : !this.logDir.equals(other.logDir));
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getInstanceHome() {
        return this.instanceHome;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public String toString() {
        return "[instanceName=" + this.instanceName + ", instanceHome=" + this.instanceHome + ", logDir=" + this.logDir + "]";
    }

    public StatementList getInitStatement() {
        return this.initStatement;
    }

    public CreateRunScript getCreateRunScript() {
        return this.createRunScript;
    }
}

