/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.AcceptsStatementVisitor;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementVisitor;
import org.jclouds.scriptbuilder.util.Utils;

public class ScriptBuilder
implements Statement,
AcceptsStatementVisitor {
    @VisibleForTesting
    List<Statement> statements = Lists.newArrayList();
    @VisibleForTesting
    Map<String, Map<String, String>> variableScopes = Maps.newLinkedHashMap();
    @VisibleForTesting
    List<String> variablesToUnset = Lists.newArrayList("path", "javaHome", "libraryPath");

    public ScriptBuilder addStatement(Statement statement) {
        this.statements.add(Preconditions.checkNotNull(statement, "statement"));
        return this;
    }

    public ScriptBuilder unsetEnvironmentVariable(String name) {
        this.variablesToUnset.add(Preconditions.checkNotNull(name, "name"));
        return this;
    }

    public ScriptBuilder addEnvironmentVariableScope(String scopeName, Map<String, String> variables) {
        this.variableScopes.put(Preconditions.checkNotNull(scopeName, "scopeName"), Preconditions.checkNotNull(variables, "variables"));
        return this;
    }

    @Override
    public String render(OsFamily osFamily) {
        LinkedHashMap<String, String> functions = Maps.newLinkedHashMap();
        functions.put("abort", Utils.writeFunctionFromResource("abort", osFamily));
        for (Map.Entry<String, Map<String, String>> entry : this.variableScopes.entrySet()) {
            functions.put(entry.getKey(), Utils.writeFunction(entry.getKey(), Utils.writeVariableExporters(entry.getValue())));
        }
        final Map<String, String> tokenValueMap = ShellToken.tokenValueMap(osFamily);
        StringBuilder builder = new StringBuilder();
        builder.append(ShellToken.BEGIN_SCRIPT.to(osFamily));
        builder.append(Utils.writeUnsetVariables(Lists.newArrayList(Iterables.transform(this.variablesToUnset, new Function<String, String>(){

            @Override
            public String apply(String from) {
                if (tokenValueMap.containsKey(from + "Variable")) {
                    return Utils.FUNCTION_UPPER_UNDERSCORE_TO_LOWER_CAMEL.apply((String)tokenValueMap.get(from + "Variable"));
                }
                return from;
            }
        })), osFamily));
        this.resolveFunctionDependencies(functions, osFamily);
        if (functions.size() > 0) {
            builder.append(ShellToken.BEGIN_FUNCTIONS.to(osFamily));
            for (String function : functions.values()) {
                builder.append(Utils.replaceTokens(function, tokenValueMap));
            }
            builder.append(ShellToken.END_FUNCTIONS.to(osFamily));
        }
        builder.append(Utils.writeZeroPath(osFamily));
        StringBuilder statementBuilder = new StringBuilder();
        for (Statement statement : this.statements) {
            statementBuilder.append(statement.render(osFamily));
        }
        builder.append(statementBuilder.toString().replaceAll(ShellToken.RETURN.to(osFamily), ShellToken.EXIT.to(osFamily)));
        builder.append(ShellToken.END_SCRIPT.to(osFamily));
        return builder.toString();
    }

    @VisibleForTesting
    void resolveFunctionDependencies(Map<String, String> functions, final OsFamily osFamily) {
        Iterable<String> dependentFunctions = Iterables.concat(Iterables.transform(this.statements, new Function<Statement, Iterable<String>>(){

            @Override
            public Iterable<String> apply(Statement from) {
                return from.functionDependencies(osFamily);
            }
        }));
        ArrayList<String> unresolvedFunctions = Lists.newArrayList(dependentFunctions);
        Iterables.removeAll(unresolvedFunctions, functions.keySet());
        for (String functionName : unresolvedFunctions) {
            functions.put(functionName, Utils.writeFunctionFromResource(functionName, osFamily));
        }
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableSet.of();
    }

    @Override
    public void accept(StatementVisitor visitor) {
        for (Statement statement : this.statements) {
            visitor.visit(statement);
        }
    }
}

