/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

public class CreateFile
implements Statement {
    public static final String MARKER = "END_OF_FILE";
    final String path;
    final Iterable<String> lines;
    final String marker;
    public static final Pattern REDIRECT_FD_PATTERN = Pattern.compile(".*[0-2]>>.*");

    public CreateFile(String path, Iterable<String> lines) {
        this(path, lines, MARKER);
    }

    public CreateFile(String path, Iterable<String> lines, String marker) {
        this.path = Preconditions.checkNotNull(path, "path");
        this.lines = Preconditions.checkNotNull(lines, "lines");
        this.marker = Preconditions.checkNotNull(marker, "marker");
        Preconditions.checkState(Iterables.size(lines) > 0, "you must pass something to execute");
    }

    public static String escapeVarTokens(String toEscape, OsFamily family) {
        HashMap<String, String> inputToEscape = Maps.newHashMap();
        for (ShellToken token : ImmutableList.of(ShellToken.VARL, ShellToken.VARR)) {
            if (token.to(family).equals("")) continue;
            String tokenS = "{" + token.toString().toLowerCase() + "}";
            inputToEscape.put(tokenS, "{escvar}" + tokenS);
        }
        for (Map.Entry entry : inputToEscape.entrySet()) {
            toEscape = toEscape.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return toEscape;
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return Collections.emptyList();
    }

    @Override
    public String render(OsFamily family) {
        ArrayList<Statement> statements = Lists.newArrayList();
        if (family == OsFamily.UNIX) {
            StringBuilder builder = new StringBuilder();
            this.hereFile(this.path, builder);
            statements.add(Statements.interpret(builder.toString()));
        } else {
            for (String line : this.lines) {
                statements.add(this.appendToFile(line, this.path, family));
            }
        }
        return new StatementList(statements).render(family);
    }

    private void hereFile(String path, StringBuilder builder) {
        builder.append("cat > ").append(path).append(" <<'").append(this.marker).append("'\n");
        for (String line : this.lines) {
            builder.append(line).append("\n");
        }
        builder.append(this.marker).append("\n");
    }

    private Statement appendToFile(String line, String path, OsFamily family) {
        String quote = "";
        if (!ShellToken.VQ.to(family).equals("")) {
            quote = "'";
        } else {
            line = CreateFile.escapeVarTokens(line, family);
        }
        return Statements.interpret(CreateFile.addSpaceToEnsureWeDontAccidentallyRedirectFd(String.format("echo %s%s%s>>%s{lf}", quote, line, quote, path)));
    }

    static String addSpaceToEnsureWeDontAccidentallyRedirectFd(String line) {
        return REDIRECT_FD_PATTERN.matcher(line).matches() ? line.replace(">>", " >>") : line;
    }
}

