/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.jclouds.scriptbuilder.domain.AppendFile;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

public class CreateOrOverwriteFile
extends AppendFile {
    public CreateOrOverwriteFile(String path, Iterable<String> lines) {
        super(path, lines);
    }

    public CreateOrOverwriteFile(String path, Iterable<String> lines, String marker) {
        super(path, lines, marker);
    }

    @Override
    public String render(OsFamily family) {
        ArrayList<Statement> statements = Lists.newArrayList();
        if (family == OsFamily.UNIX) {
            StringBuilder builder = new StringBuilder();
            this.hereFile(this.path, builder);
            statements.add(Statements.interpret(builder.toString()));
        } else {
            statements.add(Statements.interpret(String.format("copy /y CON %s{lf}", this.path)));
            for (String line : this.lines) {
                statements.add(this.appendToFile(line, this.path, family));
            }
        }
        return new StatementList(statements).render(family);
    }

    @Override
    protected void hereFile(String path, StringBuilder builder) {
        builder.append("cat > ").append(path).append(" <<'").append(this.marker).append("'\n");
        for (String line : this.lines) {
            builder.append(line).append("\n");
        }
        builder.append(this.marker).append("\n");
    }
}

