/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.binders;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;

@Singleton
public class BindCreateSliceToXmlPayload
implements MapBinder {
    private final BindToStringPayload binder;

    @Inject
    BindCreateSliceToXmlPayload(BindToStringPayload binder) {
        this.binder = binder;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        String flavorId = Preconditions.checkNotNull(postParams.get("flavor_id"), "flavor_id");
        String imageId = Preconditions.checkNotNull(postParams.get("image_id"), "image_id");
        String name = Preconditions.checkNotNull(postParams.get("name"), "name");
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><slice>");
        builder.append("<flavor-id type=\"integer\">").append(flavorId).append("</flavor-id>");
        builder.append("<image-id type=\"integer\">").append(imageId).append("</image-id>");
        builder.append("<name>").append(name).append("</name>");
        builder.append("</slice>");
        request = this.binder.bindToRequest(request, builder.toString());
        request.getPayload().getContentMetadata().setContentType("application/xml");
        return request;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException("should use map params");
    }
}

