/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.compute.strategy;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.suppliers.JustProvider;
import org.jclouds.slicehost.SlicehostClient;
import org.jclouds.slicehost.domain.Flavor;
import org.jclouds.slicehost.domain.Image;
import org.jclouds.slicehost.domain.Slice;

@Singleton
public class SlicehostComputeServiceAdapter
implements ComputeServiceAdapter<Slice, Flavor, Image, Location> {
    protected final SlicehostClient client;
    protected final JustProvider locationSupplier;

    @Inject
    protected SlicehostComputeServiceAdapter(SlicehostClient client, JustProvider locationSupplier) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.locationSupplier = Preconditions.checkNotNull(locationSupplier, "locationSupplier");
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<Slice> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Slice server = this.client.createSlice(name, Integer.parseInt(template.getImage().getProviderId()), Integer.parseInt(template.getHardware().getProviderId()));
        return new ComputeServiceAdapter.NodeAndInitialCredentials<Slice>(server, server.getId() + "", LoginCredentials.builder().password(server.getRootPassword()).build());
    }

    @Override
    public Iterable<Flavor> listHardwareProfiles() {
        return this.client.listFlavors();
    }

    @Override
    public Iterable<Image> listImages() {
        return this.client.listImages();
    }

    @Override
    public Iterable<Slice> listNodes() {
        return this.client.listSlices();
    }

    @Override
    public Iterable<Location> listLocations() {
        return this.locationSupplier.get();
    }

    @Override
    public Slice getNode(String id) {
        int serverId = Integer.parseInt(id);
        return this.client.getSlice(serverId);
    }

    @Override
    public void destroyNode(String id) {
        int serverId = Integer.parseInt(id);
        this.client.destroySlice(serverId);
    }

    @Override
    public void rebootNode(String id) {
        int sliceId = Integer.parseInt(id);
        this.client.hardRebootSlice(sliceId);
    }

    @Override
    public void resumeNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }

    @Override
    public void suspendNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }
}

