/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.filters;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.utils.ModifyRequest;

@Singleton
public class SlicehostBasic
implements HttpRequestFilter {
    private final String apikey;

    @Inject
    public SlicehostBasic(@Named(value="jclouds.identity") String apikey) {
        this.apikey = Preconditions.checkNotNull(apikey, "apikey");
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ModifyRequest.replaceHeader(request, "Authorization", String.format("Basic %s", CryptoStreams.base64(this.apikey.getBytes())));
    }
}

