/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.JustProvider;
import org.jclouds.softlayer.domain.Address;
import org.jclouds.softlayer.domain.Datacenter;

public class DatacenterToLocation
implements Function<Datacenter, Location> {
    private final JustProvider provider;

    @Inject
    public DatacenterToLocation(JustProvider provider) {
        this.provider = Preconditions.checkNotNull(provider, "provider");
    }

    @Override
    public Location apply(Datacenter datacenter) {
        return new LocationBuilder().scope(LocationScope.ZONE).metadata(ImmutableMap.<String, Object>of()).description(datacenter.getLongName()).id(Long.toString(datacenter.getId())).iso3166Codes(this.createIso3166Codes(datacenter.getLocationAddress())).parent((Location)Iterables.getOnlyElement(this.provider.get())).build();
    }

    private Iterable<String> createIso3166Codes(Address address) {
        if (address == null) {
            return ImmutableSet.of();
        }
        String country = Strings.nullToEmpty(address.getCountry()).trim();
        if (country.isEmpty()) {
            return ImmutableSet.of();
        }
        String state = Strings.nullToEmpty(address.getState()).trim();
        if (state.isEmpty()) {
            return ImmutableSet.of(address.getCountry());
        }
        return ImmutableSet.of("" + country + "-" + state);
    }
}

