/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.logging.Logger;
import org.jclouds.softlayer.compute.functions.ProductItems;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;

@Singleton
public class ProductItemToImage
implements Function<ProductItem, Image> {
    private static final Pattern OS_BITS_PATTERN = Pattern.compile(".*\\((\\d+) ?bit\\).*");
    private static final String CENTOS = "CentOS";
    private static final String DEBIAN = "Debian GNU/Linux";
    private static final String FEDORA = "Fedora Release";
    private static final String RHEL = "Red Hat Enterprise Linux";
    private static final String UBUNTU = "Ubuntu Linux";
    private static final String WINDOWS = "Windows Server";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Override
    public Image apply(ProductItem productItem) {
        Preconditions.checkNotNull(productItem, "productItem");
        OsFamily family = ProductItemToImage.osFamily().apply(productItem);
        Integer bits = ProductItemToImage.osBits().apply(productItem);
        OperatingSystem os = OperatingSystem.builder().description(productItem.getDescription()).family(family).version(ProductItemToImage.osVersion().apply(productItem)).is64Bit(bits.equals(64)).build();
        return new ImageBuilder().ids(ProductItemToImage.imageId().apply(productItem)).description(productItem.getDescription()).operatingSystem(os).build();
    }

    public static Function<ProductItem, OsFamily> osFamily() {
        return new Function<ProductItem, OsFamily>(){

            @Override
            public OsFamily apply(ProductItem productItem) {
                Preconditions.checkNotNull(productItem, "productItem");
                String description = productItem.getDescription();
                if (description.startsWith(ProductItemToImage.CENTOS)) {
                    return OsFamily.CENTOS;
                }
                if (description.startsWith(ProductItemToImage.DEBIAN)) {
                    return OsFamily.DEBIAN;
                }
                if (description.startsWith(ProductItemToImage.FEDORA)) {
                    return OsFamily.FEDORA;
                }
                if (description.startsWith(ProductItemToImage.RHEL)) {
                    return OsFamily.RHEL;
                }
                if (description.startsWith(ProductItemToImage.UBUNTU)) {
                    return OsFamily.UBUNTU;
                }
                if (description.startsWith(ProductItemToImage.WINDOWS)) {
                    return OsFamily.WINDOWS;
                }
                return OsFamily.UNRECOGNIZED;
            }
        };
    }

    public static Function<ProductItem, String> osVersion() {
        return new Function<ProductItem, String>(){

            @Override
            public String apply(ProductItem productItem) {
                Preconditions.checkNotNull(productItem, "productItem");
                String description = productItem.getDescription();
                OsFamily family = ProductItemToImage.osFamily().apply(productItem);
                if (family.equals((Object)OsFamily.CENTOS)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.CENTOS);
                }
                if (family.equals((Object)OsFamily.DEBIAN)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.DEBIAN);
                }
                if (family.equals((Object)OsFamily.FEDORA)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.FEDORA);
                }
                if (family.equals((Object)OsFamily.RHEL)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.RHEL);
                }
                if (family.equals((Object)OsFamily.UBUNTU)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.UBUNTU);
                }
                if (family.equals((Object)OsFamily.WINDOWS)) {
                    return ProductItemToImage.parseVersion(description, ProductItemToImage.WINDOWS);
                }
                throw new NoSuchElementException("No os version for item:" + productItem);
            }
        };
    }

    private static String parseVersion(String description, String os) {
        String noOsName = description.replaceFirst(os, "").trim();
        return noOsName.split(" ")[0];
    }

    public static Function<ProductItem, Integer> osBits() {
        return new Function<ProductItem, Integer>(){

            @Override
            public Integer apply(ProductItem productItem) {
                Preconditions.checkNotNull(productItem, "productItem");
                Matcher m = OS_BITS_PATTERN.matcher(productItem.getDescription());
                if (m.matches()) {
                    return Integer.parseInt(m.group(1));
                }
                throw new NoSuchElementException("Cannot determine os-bits for item:" + productItem);
            }
        };
    }

    public static Function<ProductItem, String> imageId() {
        return new Function<ProductItem, String>(){

            @Override
            public String apply(ProductItem productItem) {
                Preconditions.checkNotNull(productItem, "productItem");
                ProductItemPrice price = ProductItems.price().apply(productItem);
                return "" + price.getId();
            }
        };
    }
}

