/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.softlayer.compute.functions.ProductItems;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.predicates.ProductItemPredicates;

@Singleton
public class ProductItemsToHardware
implements Function<Iterable<ProductItem>, Hardware> {
    private static final String GUEST_DISK_CATEGORY_REGEX = "guest_disk[0-9]";
    private static final String FIRST_GUEST_DISK = "guest_disk0";
    private static final String STORAGE_AREA_NETWORK = "SAN";
    private static final String RAM_CATEGORY = "ram";
    private static final String CPU_DESCRIPTION_REGEX = "(Private )?[0-9]+ x ([.0-9]+) GHz Core[s]?";
    private static final double DEFAULT_CORE_SPEED = 2.0;
    private final Pattern cpuDescriptionRegex;
    private final Pattern diskCategoryRegex;

    @Inject
    public ProductItemsToHardware() {
        this(Pattern.compile(CPU_DESCRIPTION_REGEX), Pattern.compile(GUEST_DISK_CATEGORY_REGEX));
    }

    public ProductItemsToHardware(Pattern cpuDescriptionRegex, Pattern diskCategoryRegex) {
        this.cpuDescriptionRegex = Preconditions.checkNotNull(cpuDescriptionRegex, "cpuDescriptionRegex");
        this.diskCategoryRegex = Preconditions.checkNotNull(diskCategoryRegex, "diskCategoryRegex");
    }

    @Override
    public Hardware apply(Iterable<ProductItem> items) {
        ProductItem coresItem = Iterables.getOnlyElement(Iterables.filter(items, ProductItemPredicates.matches(this.cpuDescriptionRegex)));
        ProductItem ramItem = Iterables.getOnlyElement(Iterables.filter(items, ProductItemPredicates.categoryCode(RAM_CATEGORY)));
        ProductItem volumeItem = Iterables.get(Iterables.filter(items, ProductItemPredicates.categoryCode(FIRST_GUEST_DISK)), 0);
        String hardwareId = ProductItemsToHardware.hardwareId().apply(ImmutableList.of(coresItem, ramItem, volumeItem));
        double cores = ProductItems.capacity().apply(coresItem).doubleValue();
        Matcher cpuMatcher = this.cpuDescriptionRegex.matcher(coresItem.getDescription());
        double coreSpeed = cpuMatcher.matches() ? Double.parseDouble(cpuMatcher.group(cpuMatcher.groupCount())) : 2.0;
        int ram = ProductItems.capacity().apply(ramItem).intValue();
        return new HardwareBuilder().ids(hardwareId).processors(ImmutableList.of(new Processor(cores, coreSpeed))).ram(ram).volumes(Iterables.transform(Iterables.filter(items, ProductItemPredicates.categoryCodeMatches(this.diskCategoryRegex)), new Function<ProductItem, Volume>(){

            @Override
            public Volume apply(ProductItem item) {
                float volumeSize = ProductItems.capacity().apply(item).floatValue();
                return new VolumeImpl(item.getId() + "", item.getDescription().indexOf(ProductItemsToHardware.STORAGE_AREA_NETWORK) != -1 ? Volume.Type.SAN : Volume.Type.LOCAL, Float.valueOf(volumeSize), null, ProductItemPredicates.categoryCode(ProductItemsToHardware.FIRST_GUEST_DISK).apply(item), false);
            }
        })).build();
    }

    public static Function<List<ProductItem>, String> hardwareId() {
        return new Function<List<ProductItem>, String>(){

            @Override
            public String apply(List<ProductItem> productItems) {
                StringBuilder builder = new StringBuilder();
                for (ProductItem item : productItems) {
                    ProductItemPrice price = ProductItems.price().apply(item);
                    builder.append(price.getId()).append(",");
                }
                return builder.toString().substring(0, builder.lastIndexOf(","));
            }
        };
    }
}

