/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.FindResourceInSet;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.compute.functions.ProductItemToImage;
import org.jclouds.softlayer.compute.functions.ProductItems;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductOrder;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.predicates.ProductItemPredicates;

@Singleton
public class VirtualGuestToNodeMetadata
implements Function<VirtualGuest, NodeMetadata> {
    public static final Map<VirtualGuest.State, NodeState> serverStateToNodeState = ImmutableMap.builder().put(VirtualGuest.State.HALTED, NodeState.PENDING).put(VirtualGuest.State.PAUSED, NodeState.SUSPENDED).put(VirtualGuest.State.RUNNING, NodeState.RUNNING).put(VirtualGuest.State.UNRECOGNIZED, NodeState.UNRECOGNIZED).build();
    private final FindLocationForVirtualGuest findLocationForVirtualGuest;
    private final GetHardwareForVirtualGuest getHardwareForVirtualGuest;
    private final GetImageForVirtualGuest getImageForVirtualGuest;

    @Inject
    VirtualGuestToNodeMetadata(FindLocationForVirtualGuest findLocationForVirtualGuest, GetHardwareForVirtualGuest getHardwareForVirtualGuest, GetImageForVirtualGuest getImageForVirtualGuest) {
        this.findLocationForVirtualGuest = Preconditions.checkNotNull(findLocationForVirtualGuest, "findLocationForVirtualGuest");
        this.getHardwareForVirtualGuest = Preconditions.checkNotNull(getHardwareForVirtualGuest, "getHardwareForVirtualGuest");
        this.getImageForVirtualGuest = Preconditions.checkNotNull(getImageForVirtualGuest, "getImageForVirtualGuest");
    }

    @Override
    public NodeMetadata apply(VirtualGuest from) {
        Hardware hardware;
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getHostname());
        builder.hostname(from.getHostname());
        builder.location((Location)this.findLocationForVirtualGuest.apply(from));
        builder.group(ComputeServiceUtils.parseGroupFromName(from.getHostname()));
        Image image = this.getImageForVirtualGuest.getImage(from);
        if (image != null) {
            builder.imageId(image.getId());
            builder.operatingSystem(image.getOperatingSystem());
        }
        if ((hardware = this.getHardwareForVirtualGuest.getHardware(from)) != null) {
            builder.hardware(hardware);
        }
        builder.state(serverStateToNodeState.get((Object)from.getPowerState().getKeyName()));
        if (from.getPrimaryIpAddress() != null) {
            builder.publicAddresses(ImmutableSet.of(from.getPrimaryIpAddress()));
        }
        if (from.getPrimaryBackendIpAddress() != null) {
            builder.privateAddresses(ImmutableSet.of(from.getPrimaryBackendIpAddress()));
        }
        return builder.build();
    }

    @Singleton
    public static class GetImageForVirtualGuest {
        private SoftLayerClient client;

        @Inject
        public GetImageForVirtualGuest(SoftLayerClient client) {
            this.client = client;
        }

        public Image getImage(VirtualGuest guest) {
            if (guest.getStartCpus() < 1) {
                return null;
            }
            ProductOrder order = this.client.getVirtualGuestClient().getOrderTemplate(guest.getId());
            if (order == null) {
                return null;
            }
            Iterable<ProductItem> items = Iterables.transform(order.getPrices(), ProductItems.item());
            ProductItem os = Iterables.find(items, ProductItemPredicates.categoryCode("os"));
            return new ProductItemToImage().apply(os);
        }
    }

    @Singleton
    public static class GetHardwareForVirtualGuest {
        private final SoftLayerClient client;
        private final Function<Iterable<ProductItem>, Hardware> productItemsToHardware;

        @Inject
        public GetHardwareForVirtualGuest(SoftLayerClient client, Function<Iterable<ProductItem>, Hardware> productItemsToHardware) {
            this.client = Preconditions.checkNotNull(client, "client");
            this.productItemsToHardware = Preconditions.checkNotNull(productItemsToHardware, "productItemsToHardware");
        }

        public Hardware getHardware(VirtualGuest guest) {
            if (guest.getStartCpus() < 1) {
                return null;
            }
            ProductOrder order = this.client.getVirtualGuestClient().getOrderTemplate(guest.getId());
            if (order == null) {
                return null;
            }
            Iterable<ProductItem> items = Iterables.transform(order.getPrices(), ProductItems.item());
            return this.productItemsToHardware.apply(items);
        }
    }

    @Singleton
    public static class FindLocationForVirtualGuest
    extends FindResourceInSet<VirtualGuest, Location> {
        @Inject
        public FindLocationForVirtualGuest(@Memoized Supplier<Set<? extends Location>> location) {
            super(location);
        }

        @Override
        public boolean matches(VirtualGuest from, Location input) {
            Datacenter dc = from.getDatacenter();
            if (dc == null) {
                return false;
            }
            return input.getId().equals(Integer.toString(dc.getId()));
        }
    }
}

