/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.Password;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.ProductOrder;
import org.jclouds.softlayer.domain.ProductOrderReceipt;
import org.jclouds.softlayer.domain.ProductPackage;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.predicates.ProductItemPredicates;

@Singleton
public class SoftLayerComputeServiceAdapter
implements ComputeServiceAdapter<VirtualGuest, Iterable<ProductItem>, ProductItem, Datacenter> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final SoftLayerClient client;
    private final Supplier<ProductPackage> productPackageSupplier;
    private final RetryablePredicate<VirtualGuest> loginDetailsTester;
    private final long guestLoginDelay;
    private final Pattern cpuPattern;
    private final Pattern disk0Type;
    private final float portSpeed;
    private final Iterable<ProductItemPrice> prices;

    @Inject
    public SoftLayerComputeServiceAdapter(SoftLayerClient client, VirtualGuestHasLoginDetailsPresent virtualGuestHasLoginDetailsPresent, @Memoized Supplier<ProductPackage> productPackageSupplier, Iterable<ProductItemPrice> prices, @Named(value="jclouds.softlayer.virtualguest.cpu-regex") String cpuRegex, @Named(value="jclouds.softlayer.virtualguest.disk0-type") String disk0Type, @Named(value="jclouds.softlayer.virtualguest.port-speed") float portSpeed, @Named(value="jclouds.softlayer.virtualguest.order-delay") long guestLoginDelay) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.guestLoginDelay = guestLoginDelay;
        this.productPackageSupplier = Preconditions.checkNotNull(productPackageSupplier, "productPackageSupplier");
        Preconditions.checkArgument(guestLoginDelay > 500L, "guestOrderDelay must be in milliseconds and greater than 500");
        this.loginDetailsTester = new RetryablePredicate<VirtualGuest>(virtualGuestHasLoginDetailsPresent, guestLoginDelay);
        this.cpuPattern = Pattern.compile(Preconditions.checkNotNull(cpuRegex, "cpuRegex"));
        this.prices = Preconditions.checkNotNull(prices, "prices");
        this.portSpeed = portSpeed;
        Preconditions.checkArgument(portSpeed > 0.0f, "portSpeed must be greater than zero, often 10, 100, 1000, 10000");
        this.disk0Type = Pattern.compile(".*" + Preconditions.checkNotNull(disk0Type, "disk0Type") + ".*");
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<VirtualGuest> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Preconditions.checkNotNull(template, "template was null");
        Preconditions.checkNotNull(template.getOptions(), "template options was null");
        Preconditions.checkArgument(template.getOptions().getClass().isAssignableFrom(SoftLayerTemplateOptions.class), "options class %s should have been assignable from SoftLayerTemplateOptions", template.getOptions().getClass());
        String domainName = template.getOptions().as(SoftLayerTemplateOptions.class).getDomainName();
        VirtualGuest newGuest = VirtualGuest.builder().domain(domainName).hostname(name).build();
        ProductOrder order = ProductOrder.builder().packageId(this.productPackageSupplier.get().getId()).location(template.getLocation().getId()).quantity(1).useHourlyPricing(true).prices(this.getPrices(template)).virtualGuest(newGuest).build();
        this.logger.debug(">> ordering new virtualGuest domain(%s) hostname(%s)", domainName, name);
        ProductOrderReceipt productOrderReceipt = this.client.getVirtualGuestClient().orderVirtualGuest(order);
        VirtualGuest result = Iterables.get(productOrderReceipt.getOrderDetails().getVirtualGuests(), 0);
        this.logger.trace("<< virtualGuest(%s)", result.getId());
        this.logger.debug(">> awaiting login details for virtualGuest(%s)", result.getId());
        boolean orderInSystem = this.loginDetailsTester.apply(result);
        this.logger.trace("<< virtualGuest(%s) complete(%s)", result.getId(), orderInSystem);
        Preconditions.checkState(orderInSystem, "order for guest %s doesn't have login details within %sms", result, Long.toString(this.guestLoginDelay));
        result = this.client.getVirtualGuestClient().getVirtualGuest(result.getId());
        Password pw = Iterables.get(result.getOperatingSystem().getPasswords(), 0);
        return new ComputeServiceAdapter.NodeAndInitialCredentials<VirtualGuest>(result, result.getId() + "", LoginCredentials.builder().user(pw.getUsername()).password(pw.getPassword()).build());
    }

    private Iterable<ProductItemPrice> getPrices(Template template) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        int imageId = Integer.parseInt(template.getImage().getId());
        result.add(ProductItemPrice.builder().id(imageId).build());
        Iterable<String> hardwareIds = Splitter.on(",").split(template.getHardware().getId());
        for (String hardwareId : hardwareIds) {
            int id = Integer.parseInt(hardwareId);
            result.add(ProductItemPrice.builder().id(id).build());
        }
        ProductItem uplinkItem = Iterables.find(this.productPackageSupplier.get().getItems(), Predicates.and(ProductItemPredicates.capacity(Float.valueOf(this.portSpeed)), ProductItemPredicates.categoryCode("port_speed")));
        result.add(Iterables.get(uplinkItem.getPrices(), 0));
        result.addAll(this.prices);
        return result.build();
    }

    @Override
    public Iterable<Iterable<ProductItem>> listHardwareProfiles() {
        ProductPackage productPackage = this.productPackageSupplier.get();
        Set<ProductItem> items = productPackage.getItems();
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (ProductItem cpuItem : Iterables.filter(items, ProductItemPredicates.matches(this.cpuPattern))) {
            for (ProductItem ramItem : Iterables.filter(items, ProductItemPredicates.categoryCode("ram"))) {
                for (ProductItem sanItem : Iterables.filter(items, Predicates.and(ProductItemPredicates.matches(this.disk0Type), ProductItemPredicates.categoryCode("guest_disk0")))) {
                    result.add(ImmutableSet.of(cpuItem, ramItem, sanItem));
                }
            }
        }
        return result.build();
    }

    @Override
    public Iterable<ProductItem> listImages() {
        return Iterables.filter(this.productPackageSupplier.get().getItems(), ProductItemPredicates.categoryCode("os"));
    }

    @Override
    public Iterable<VirtualGuest> listNodes() {
        return Iterables.filter(this.client.getVirtualGuestClient().listVirtualGuests(), new Predicate<VirtualGuest>(){

            @Override
            public boolean apply(VirtualGuest arg0) {
                boolean hasBillingItem;
                boolean bl = hasBillingItem = arg0.getBillingItemId() != -1;
                if (hasBillingItem) {
                    return true;
                }
                SoftLayerComputeServiceAdapter.this.logger.trace("guest invalid, as it has no billing item %s", arg0);
                return false;
            }
        });
    }

    @Override
    public Iterable<Datacenter> listLocations() {
        return this.productPackageSupplier.get().getDatacenters();
    }

    @Override
    public VirtualGuest getNode(String id) {
        long serverId = Long.parseLong(id);
        return this.client.getVirtualGuestClient().getVirtualGuest(serverId);
    }

    @Override
    public void destroyNode(String id) {
        VirtualGuest guest = this.getNode(id);
        if (guest == null) {
            return;
        }
        if (guest.getBillingItemId() == -1) {
            throw new IllegalStateException(String.format("no billing item for guest(%s) so we cannot cancel the order", id));
        }
        this.logger.debug(">> canceling service for guest(%s) billingItem(%s)", id, guest.getBillingItemId());
        this.client.getVirtualGuestClient().cancelService(guest.getBillingItemId());
    }

    @Override
    public void rebootNode(String id) {
        this.client.getVirtualGuestClient().rebootHardVirtualGuest(Long.parseLong(id));
    }

    @Override
    public void resumeNode(String id) {
        this.client.getVirtualGuestClient().resumeVirtualGuest(Long.parseLong(id));
    }

    @Override
    public void suspendNode(String id) {
        this.client.getVirtualGuestClient().pauseVirtualGuest(Long.parseLong(id));
    }

    public static class VirtualGuestHasLoginDetailsPresent
    implements Predicate<VirtualGuest> {
        private final SoftLayerClient client;

        @Inject
        public VirtualGuestHasLoginDetailsPresent(SoftLayerClient client) {
            this.client = Preconditions.checkNotNull(client, "client was null");
        }

        @Override
        public boolean apply(VirtualGuest guest) {
            Preconditions.checkNotNull(guest, "virtual guest was null");
            VirtualGuest newGuest = this.client.getVirtualGuestClient().getVirtualGuest(guest.getId());
            boolean hasBackendIp = newGuest.getPrimaryBackendIpAddress() != null;
            boolean hasPrimaryIp = newGuest.getPrimaryIpAddress() != null;
            boolean hasPasswords = newGuest.getOperatingSystem() != null && newGuest.getOperatingSystem().getPasswords().size() > 0;
            return hasBackendIp && hasPrimaryIp && hasPasswords;
        }
    }
}

