/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.config;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.json.config.GsonModule;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.OperatingSystem;
import org.jclouds.softlayer.domain.PowerState;
import org.jclouds.softlayer.domain.VirtualGuest;

public class SoftLayerParserModule
extends AbstractModule {
    @Provides
    @Singleton
    public Map<Type, Object> provideCustomAdapterBindings() {
        return ImmutableMap.of(VirtualGuest.class, new VirtualGuestAdapter());
    }

    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
    }

    @Singleton
    public static class VirtualGuestAdapter
    implements JsonSerializer<VirtualGuest>,
    JsonDeserializer<VirtualGuest> {
        @Override
        public JsonElement serialize(VirtualGuest src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(src);
        }

        @Override
        public VirtualGuest deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.apply((VirtualGuestInternal)context.deserialize(json, (Type)((Object)VirtualGuestInternal.class)));
        }

        public VirtualGuest apply(VirtualGuestInternal in) {
            return in;
        }

        public static class BillingItem {
            private int id = -1;

            BillingItem() {
            }

            public BillingItem(int id) {
                this.id = id;
            }

            public String toString() {
                return "[id=" + this.id + "]";
            }
        }

        public static class VirtualGuestInternal
        extends VirtualGuest {
            private BillingItem billingItem;

            public VirtualGuestInternal(int accountId, Date createDate, boolean dedicatedAccountHostOnly, String domain, String fullyQualifiedDomainName, String hostname, int id, Date lastVerifiedDate, int maxCpu, String maxCpuUnits, int maxMemory, Date metricPollDate, Date modifyDate, String notes, boolean privateNetworkOnly, int startCpus, int statusId, String uuid, String primaryBackendIpAddress, String primaryIpAddress, int billingItemId, OperatingSystem operatingSystem, Datacenter datacenter, PowerState powerState) {
                super(accountId, createDate, dedicatedAccountHostOnly, domain, fullyQualifiedDomainName, hostname, id, lastVerifiedDate, maxCpu, maxCpuUnits, maxMemory, metricPollDate, modifyDate, notes, privateNetworkOnly, startCpus, statusId, uuid, primaryBackendIpAddress, primaryIpAddress, billingItemId, operatingSystem, datacenter, powerState);
            }

            @Override
            public int getBillingItemId() {
                return this.billingItem != null ? this.billingItem.id : -1;
            }
        }
    }
}

