/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class Address
implements Comparable<Address> {
    private int id = -1;
    private String country;
    private String state;
    private String description;

    public static Builder builder() {
        return new Builder();
    }

    Address() {
    }

    public Address(int id, String country, String state, String description) {
        this.id = id;
        this.country = Preconditions.checkNotNull(Strings.emptyToNull(country), "country cannot be null or empty:" + country);
        this.state = state;
        this.description = description;
    }

    @Override
    public int compareTo(Address arg0) {
        return new Integer(this.id).compareTo(arg0.getId());
    }

    public int getId() {
        return this.id;
    }

    public String getCountry() {
        return this.country;
    }

    public String getState() {
        return this.state;
    }

    public String getDescription() {
        return this.description;
    }

    public Builder toBuilder() {
        return Builder.fromAddress(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address other = (Address)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "[id=" + this.id + ", country=" + this.country + ", state=" + this.state + ", description=" + this.description + "]";
    }

    public static class Builder {
        private int id = -1;
        private String country;
        private String state;
        private String description;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Address build() {
            return new Address(this.id, this.country, this.state, this.description);
        }

        public static Builder fromAddress(Address in) {
            return Address.builder().id(in.getId()).country(in.getCountry()).state(in.getState()).description(in.getDescription());
        }
    }
}

