/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.softlayer.domain.Address;
import org.jclouds.softlayer.domain.Region;

public class Datacenter
implements Comparable<Datacenter> {
    private int id = -1;
    private String name;
    private String longName;
    private Address locationAddress;
    private Set<Region> regions = Sets.newLinkedHashSet();

    public static Builder builder() {
        return new Builder();
    }

    Datacenter() {
    }

    public Datacenter(int id, String name, String longName, Address locationAddress, Iterable<Region> regions) {
        this.id = id;
        this.name = name;
        this.longName = longName;
        this.locationAddress = locationAddress;
        this.regions = ImmutableSet.copyOf(Preconditions.checkNotNull(regions, "regions"));
    }

    @Override
    public int compareTo(Datacenter arg0) {
        return new Integer(this.id).compareTo(arg0.getId());
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLongName() {
        return this.longName;
    }

    public Address getLocationAddress() {
        return this.locationAddress;
    }

    public Set<Region> getRegions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return Builder.fromDatacenter(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Datacenter other = (Datacenter)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "[id=" + this.id + ", country=" + this.name + ", state=" + this.longName + "], locationAddress=" + this.locationAddress + ", regions=" + this.regions + "]";
    }

    public static class Builder {
        private int id = -1;
        private String name;
        private String longName;
        private Address locationAddress;
        private Set<Region> regions = Sets.newLinkedHashSet();

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder longName(String longName) {
            this.longName = longName;
            return this;
        }

        public Builder locationAddress(Address locationAddress) {
            this.locationAddress = locationAddress;
            return this;
        }

        public Builder region(Region regions) {
            this.regions.add(Preconditions.checkNotNull(regions, "regions"));
            return this;
        }

        public Builder regions(Iterable<Region> regions) {
            this.regions = ImmutableSet.copyOf(Preconditions.checkNotNull(regions, "regions"));
            return this;
        }

        public Datacenter build() {
            return new Datacenter(this.id, this.name, this.longName, this.locationAddress, this.regions);
        }

        public static Builder fromDatacenter(Datacenter in) {
            return Datacenter.builder().id(in.getId()).name(in.getName()).longName(in.getLongName()).locationAddress(in.getLocationAddress()).regions(in.getRegions());
        }
    }
}

