/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.ProductItemCategory;
import org.jclouds.softlayer.domain.ProductItemPrice;

public class ProductItem
implements Comparable<ProductItem> {
    private int id = -1;
    private String description;
    private String units;
    private Float capacity;
    private Set<ProductItemPrice> prices = Sets.newLinkedHashSet();
    private Set<ProductItemCategory> categories = Sets.newLinkedHashSet();

    public static Builder builder() {
        return new Builder();
    }

    ProductItem() {
    }

    public ProductItem(int id, String description, String units, Float capacity, Iterable<ProductItemPrice> prices, Iterable<ProductItemCategory> categories) {
        this.id = id;
        this.description = description;
        this.units = units;
        this.capacity = capacity;
        this.prices = ImmutableSet.copyOf(Preconditions.checkNotNull(prices, "prices"));
        this.categories = ImmutableSet.copyOf(Preconditions.checkNotNull(categories, "categories"));
    }

    @Override
    public int compareTo(ProductItem arg0) {
        return new Integer(this.id).compareTo(arg0.getId());
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getUnits() {
        return this.units;
    }

    @Nullable
    public Float getCapacity() {
        return this.capacity;
    }

    public Set<ProductItemPrice> getPrices() {
        return this.prices;
    }

    public Set<ProductItemCategory> getCategories() {
        return this.categories;
    }

    public Builder toBuilder() {
        return Builder.fromProductItem(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductItem other = (ProductItem)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "ProductItem [id=" + this.id + ", description=" + this.description + ", units=" + this.units + ", capacity=" + this.capacity + ", prices=" + this.prices + ", categories=" + this.categories + "]";
    }

    public static class Builder {
        private int id = -1;
        private String description;
        private String units;
        private Float capacity;
        private Set<ProductItemPrice> prices = Sets.newLinkedHashSet();
        private Set<ProductItemCategory> categories = Sets.newLinkedHashSet();

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder units(String units) {
            this.units = units;
            return this;
        }

        public Builder capacity(Float capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder price(ProductItemPrice prices) {
            this.prices.add(Preconditions.checkNotNull(prices, "prices"));
            return this;
        }

        public Builder prices(Iterable<ProductItemPrice> prices) {
            this.prices = ImmutableSet.copyOf(Preconditions.checkNotNull(prices, "prices"));
            return this;
        }

        public Builder category(ProductItemCategory categories) {
            this.categories.add(Preconditions.checkNotNull(categories, "categories"));
            return this;
        }

        public Builder categories(Iterable<ProductItemCategory> categories) {
            this.categories = ImmutableSet.copyOf(Preconditions.checkNotNull(categories, "categories"));
            return this;
        }

        public ProductItem build() {
            return new ProductItem(this.id, this.description, this.units, this.capacity, this.prices, this.categories);
        }

        public static Builder fromProductItem(ProductItem in) {
            return ProductItem.builder().id(in.getId()).description(in.getDescription()).units(in.getUnits()).capacity(in.getCapacity()).prices(in.getPrices()).categories(in.getCategories());
        }
    }
}

