/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import org.jclouds.softlayer.domain.ProductOrder;

public class ProductOrderReceipt
implements Comparable<ProductOrderReceipt> {
    private int orderId = -1;
    private ProductOrder orderDetails;

    public static Builder builder() {
        return new Builder();
    }

    ProductOrderReceipt() {
    }

    public ProductOrderReceipt(int orderId, ProductOrder orderDetails) {
        this.orderId = orderId;
        this.orderDetails = orderDetails;
    }

    @Override
    public int compareTo(ProductOrderReceipt arg0) {
        return new Integer(this.orderId).compareTo(arg0.getOrderId());
    }

    public int getOrderId() {
        return this.orderId;
    }

    public ProductOrder getOrderDetails() {
        return this.orderDetails;
    }

    public Builder toBuilder() {
        return Builder.fromAddress(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.orderId ^ this.orderId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductOrderReceipt other = (ProductOrderReceipt)obj;
        return this.orderId == other.orderId;
    }

    public String toString() {
        return "[orderId=" + this.orderId + ", orderDetails=" + this.orderDetails + "]";
    }

    public static class Builder {
        private int orderId = -1;
        private ProductOrder orderDetails;

        public Builder orderId(int orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder orderDetails(ProductOrder orderDetails) {
            this.orderDetails = orderDetails;
            return this;
        }

        public ProductOrderReceipt build() {
            return new ProductOrderReceipt(this.orderId, this.orderDetails);
        }

        public static Builder fromAddress(ProductOrderReceipt in) {
            return ProductOrderReceipt.builder().orderId(in.getOrderId()).orderDetails(in.getOrderDetails());
        }
    }
}

