/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class Region
implements Comparable<Region> {
    private int sortOrder = 0;
    private String keyname;
    private String description;

    public static Builder builder() {
        return new Builder();
    }

    Region() {
    }

    public Region(String keyname, String description) {
        this.keyname = Preconditions.checkNotNull(Strings.emptyToNull(keyname), "keyname cannot be null or empty:" + keyname);
        this.description = Preconditions.checkNotNull(Strings.emptyToNull(description), "country cannot be null or empty:" + description);
    }

    @Override
    public int compareTo(Region arg0) {
        return new Integer(this.sortOrder).compareTo(arg0.sortOrder);
    }

    public String getKeyname() {
        return this.keyname;
    }

    public String getDescription() {
        return this.description;
    }

    public Builder toBuilder() {
        return Builder.fromAddress(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        if (this.sortOrder != region.sortOrder) {
            return false;
        }
        if (!this.description.equals(region.description)) {
            return false;
        }
        return this.keyname.equals(region.keyname);
    }

    public int hashCode() {
        int result = this.sortOrder;
        result = 31 * result + this.keyname.hashCode();
        result = 31 * result + this.description.hashCode();
        return result;
    }

    public String toString() {
        return "[keyname=" + this.keyname + ", description=" + this.description + "]";
    }

    public static class Builder {
        private String keyname;
        private String description;

        public Builder keyname(String keyname) {
            this.keyname = keyname;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Region build() {
            return new Region(this.keyname, this.description);
        }

        public static Builder fromAddress(Region in) {
            return Region.builder().keyname(in.getKeyname()).description(in.getDescription());
        }
    }
}

