/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.OperatingSystem;
import org.jclouds.softlayer.domain.PowerState;

public class VirtualGuest
implements Comparable<VirtualGuest> {
    private int accountId = -1;
    private Date createDate;
    @SerializedName(value="dedicatedAccountHostOnlyFlag")
    private boolean dedicatedAccountHostOnly;
    private String domain;
    private String fullyQualifiedDomainName;
    private String hostname;
    private int id = -1;
    private Date lastVerifiedDate;
    private int maxCpu = -1;
    private String maxCpuUnits;
    private int maxMemory = -1;
    private Date metricPollDate;
    private Date modifyDate;
    private String notes;
    @SerializedName(value="privateNetworkOnlyFlag")
    private boolean privateNetworkOnly;
    private int startCpus = -1;
    private int statusId = -1;
    private String uuid;
    private String primaryBackendIpAddress;
    private String primaryIpAddress;
    private int billingItemId = -1;
    private OperatingSystem operatingSystem;
    private Datacenter datacenter;
    private PowerState powerState;

    public static Builder builder() {
        return new Builder();
    }

    VirtualGuest() {
    }

    public VirtualGuest(int accountId, Date createDate, boolean dedicatedAccountHostOnly, String domain, String fullyQualifiedDomainName, String hostname, int id, Date lastVerifiedDate, int maxCpu, String maxCpuUnits, int maxMemory, Date metricPollDate, Date modifyDate, String notes, boolean privateNetworkOnly, int startCpus, int statusId, String uuid, String primaryBackendIpAddress, String primaryIpAddress, int billingItemId, OperatingSystem operatingSystem, Datacenter datacenter, PowerState powerState) {
        this.accountId = accountId;
        this.createDate = createDate;
        this.dedicatedAccountHostOnly = dedicatedAccountHostOnly;
        this.domain = domain;
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        this.hostname = hostname;
        this.id = id;
        this.lastVerifiedDate = lastVerifiedDate;
        this.maxCpu = maxCpu;
        this.maxCpuUnits = maxCpuUnits;
        this.maxMemory = maxMemory;
        this.metricPollDate = metricPollDate;
        this.modifyDate = modifyDate;
        this.notes = notes;
        this.privateNetworkOnly = privateNetworkOnly;
        this.startCpus = startCpus;
        this.statusId = statusId;
        this.uuid = uuid;
        this.primaryBackendIpAddress = primaryBackendIpAddress;
        this.primaryIpAddress = primaryIpAddress;
        this.billingItemId = billingItemId;
        this.operatingSystem = operatingSystem;
        this.datacenter = datacenter;
        this.powerState = powerState;
    }

    @Override
    public int compareTo(VirtualGuest arg0) {
        return new Integer(this.id).compareTo(arg0.getId());
    }

    public int getAccountId() {
        return this.accountId;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public boolean isDedicatedAccountHostOnly() {
        return this.dedicatedAccountHostOnly;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getFullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getId() {
        return this.id;
    }

    public Date getLastVerifiedDate() {
        return this.lastVerifiedDate;
    }

    public int getMaxCpu() {
        return this.maxCpu;
    }

    public String getMaxCpuUnits() {
        return this.maxCpuUnits;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    public Date getMetricPollDate() {
        return this.metricPollDate;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public String getNotes() {
        return this.notes;
    }

    public boolean isPrivateNetworkOnly() {
        return this.privateNetworkOnly;
    }

    public int getStartCpus() {
        return this.startCpus;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getPrimaryBackendIpAddress() {
        return this.primaryBackendIpAddress;
    }

    public String getPrimaryIpAddress() {
        return this.primaryIpAddress;
    }

    public int getBillingItemId() {
        return this.billingItemId;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    public PowerState getPowerState() {
        return this.powerState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.createDate == null ? 0 : this.createDate.hashCode());
        result = 31 * result + (this.dedicatedAccountHostOnly ? 1231 : 1237);
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.fullyQualifiedDomainName == null ? 0 : this.fullyQualifiedDomainName.hashCode());
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.id ^ this.id >>> 32);
        result = 31 * result + (this.lastVerifiedDate == null ? 0 : this.lastVerifiedDate.hashCode());
        result = 31 * result + this.maxCpu;
        result = 31 * result + (this.maxCpuUnits == null ? 0 : this.maxCpuUnits.hashCode());
        result = 31 * result + this.maxMemory;
        result = 31 * result + (this.metricPollDate == null ? 0 : this.metricPollDate.hashCode());
        result = 31 * result + (this.modifyDate == null ? 0 : this.modifyDate.hashCode());
        result = 31 * result + (this.notes == null ? 0 : this.notes.hashCode());
        result = 31 * result + (this.primaryBackendIpAddress == null ? 0 : this.primaryBackendIpAddress.hashCode());
        result = 31 * result + (this.primaryIpAddress == null ? 0 : this.primaryIpAddress.hashCode());
        result = 31 * result + (this.privateNetworkOnly ? 1231 : 1237);
        result = 31 * result + this.startCpus;
        result = 31 * result + this.statusId;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        result = 31 * result + (this.getBillingItemId() ^ this.getBillingItemId() >>> 32);
        result = 31 * result + (this.operatingSystem == null ? 0 : this.operatingSystem.hashCode());
        result = 31 * result + (this.datacenter == null ? 0 : this.datacenter.hashCode());
        result = 31 * result + (this.powerState == null ? 0 : this.powerState.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualGuest other = (VirtualGuest)obj;
        if (this.accountId != other.accountId) {
            return false;
        }
        if (this.createDate == null ? other.createDate != null : !this.createDate.equals(other.createDate)) {
            return false;
        }
        if (this.dedicatedAccountHostOnly != other.dedicatedAccountHostOnly) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.fullyQualifiedDomainName == null ? other.fullyQualifiedDomainName != null : !this.fullyQualifiedDomainName.equals(other.fullyQualifiedDomainName)) {
            return false;
        }
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.lastVerifiedDate == null ? other.lastVerifiedDate != null : !this.lastVerifiedDate.equals(other.lastVerifiedDate)) {
            return false;
        }
        if (this.maxCpu != other.maxCpu) {
            return false;
        }
        if (this.maxCpuUnits == null ? other.maxCpuUnits != null : !this.maxCpuUnits.equals(other.maxCpuUnits)) {
            return false;
        }
        if (this.maxMemory != other.maxMemory) {
            return false;
        }
        if (this.metricPollDate == null ? other.metricPollDate != null : !this.metricPollDate.equals(other.metricPollDate)) {
            return false;
        }
        if (this.modifyDate == null ? other.modifyDate != null : !this.modifyDate.equals(other.modifyDate)) {
            return false;
        }
        if (this.notes == null ? other.notes != null : !this.notes.equals(other.notes)) {
            return false;
        }
        if (this.primaryBackendIpAddress == null ? other.primaryBackendIpAddress != null : !this.primaryBackendIpAddress.equals(other.primaryBackendIpAddress)) {
            return false;
        }
        if (this.primaryIpAddress == null ? other.primaryIpAddress != null : !this.primaryIpAddress.equals(other.primaryIpAddress)) {
            return false;
        }
        if (this.privateNetworkOnly != other.privateNetworkOnly) {
            return false;
        }
        if (this.startCpus != other.startCpus) {
            return false;
        }
        if (this.statusId != other.statusId) {
            return false;
        }
        if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
            return false;
        }
        if (this.getBillingItemId() != other.getBillingItemId()) {
            return false;
        }
        if (this.operatingSystem == null ? other.operatingSystem != null : !this.operatingSystem.equals(other.operatingSystem)) {
            return false;
        }
        if (this.datacenter == null ? other.datacenter != null : !this.datacenter.equals(other.datacenter)) {
            return false;
        }
        return !(this.powerState == null ? other.powerState != null : !this.powerState.equals(other.powerState));
    }

    public String toString() {
        return "[accountId=" + this.accountId + ", createDate=" + this.createDate + ", dedicatedAccountHostOnly=" + this.dedicatedAccountHostOnly + ", domain=" + this.domain + ", fullyQualifiedDomainName=" + this.fullyQualifiedDomainName + ", hostname=" + this.hostname + ", id=" + this.id + ", lastVerifiedDate=" + this.lastVerifiedDate + ", maxCpu=" + this.maxCpu + ", maxCpuUnits=" + this.maxCpuUnits + ", maxMemory=" + this.maxMemory + ", metricPollDate=" + this.metricPollDate + ", modifyDate=" + this.modifyDate + ", notes=" + this.notes + ", primaryBackendIpAddress=" + this.primaryBackendIpAddress + ", primaryIpAddress=" + this.primaryIpAddress + ", privateNetworkOnly=" + this.privateNetworkOnly + ", startCpus=" + this.startCpus + ", statusId=" + this.statusId + ", uuid=" + this.uuid + ", billingItemId=" + this.getBillingItemId() + ", operatingSystem=" + this.operatingSystem + ", datacenter=" + this.datacenter + ", powerState=" + this.powerState + "]";
    }

    public static enum State {
        HALTED,
        PAUSED,
        RUNNING,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(state, "state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private int id = -1;
        private int accountId = -1;
        private Date createDate;
        private boolean dedicatedAccountHostOnly;
        private String hostname;
        private String domain;
        private String fullyQualifiedDomainName;
        private Date lastVerifiedDate;
        private int maxCpu = -1;
        private String maxCpuUnits;
        private int maxMemory = -1;
        private Date metricPollDate;
        private Date modifyDate;
        private String notes;
        private boolean privateNetworkOnly;
        private int startCpus = -1;
        private int statusId = -1;
        private String uuid;
        private String primaryBackendIpAddress;
        private String primaryIpAddress;
        private int billingItemId;
        private OperatingSystem operatingSystem;
        private Datacenter datacenter;
        private PowerState powerState;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder accountId(int accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder createDate(Date createDate) {
            this.createDate = createDate;
            return this;
        }

        public Builder dedicatedAccountHostOnly(boolean dedicatedAccountHostOnly) {
            this.dedicatedAccountHostOnly = dedicatedAccountHostOnly;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder fullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
            return this;
        }

        public Builder lastVerifiedDate(Date lastVerifiedDate) {
            this.lastVerifiedDate = lastVerifiedDate;
            return this;
        }

        public Builder maxCpu(int maxCpu) {
            this.maxCpu = maxCpu;
            return this;
        }

        public Builder maxCpuUnits(String maxCpuUnits) {
            this.maxCpuUnits = maxCpuUnits;
            return this;
        }

        public Builder maxMemory(int maxMemory) {
            this.maxMemory = maxMemory;
            return this;
        }

        public Builder metricPollDate(Date metricPollDate) {
            this.metricPollDate = metricPollDate;
            return this;
        }

        public Builder modifyDate(Date modifyDate) {
            this.modifyDate = modifyDate;
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public Builder privateNetworkOnly(boolean privateNetworkOnly) {
            this.privateNetworkOnly = privateNetworkOnly;
            return this;
        }

        public Builder startCpus(int startCpus) {
            this.startCpus = startCpus;
            return this;
        }

        public Builder statusId(int statusId) {
            this.statusId = statusId;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder primaryBackendIpAddress(String primaryBackendIpAddress) {
            this.primaryBackendIpAddress = primaryBackendIpAddress;
            return this;
        }

        public Builder primaryIpAddress(String primaryIpAddress) {
            this.primaryIpAddress = primaryIpAddress;
            return this;
        }

        public Builder billingItemId(int billingItemId) {
            this.billingItemId = billingItemId;
            return this;
        }

        public Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public Builder datacenter(Datacenter datacenter) {
            this.datacenter = datacenter;
            return this;
        }

        public Builder powerState(PowerState powerState) {
            this.powerState = powerState;
            return this;
        }

        public VirtualGuest build() {
            return new VirtualGuest(this.accountId, this.createDate, this.dedicatedAccountHostOnly, this.domain, this.fullyQualifiedDomainName, this.hostname, this.id, this.lastVerifiedDate, this.maxCpu, this.maxCpuUnits, this.maxMemory, this.metricPollDate, this.modifyDate, this.notes, this.privateNetworkOnly, this.startCpus, this.statusId, this.uuid, this.primaryBackendIpAddress, this.primaryIpAddress, this.billingItemId, this.operatingSystem, this.datacenter, this.powerState);
        }

        public static Builder fromVirtualGuest(VirtualGuest in) {
            return VirtualGuest.builder().accountId(in.getAccountId()).createDate(in.getCreateDate()).dedicatedAccountHostOnly(in.isDedicatedAccountHostOnly()).domain(in.getDomain()).fullyQualifiedDomainName(in.getFullyQualifiedDomainName()).hostname(in.getHostname()).id(in.getId()).lastVerifiedDate(in.getLastVerifiedDate()).maxCpu(in.getMaxCpu()).maxCpuUnits(in.getMaxCpuUnits()).maxMemory(in.getMaxMemory()).metricPollDate(in.getMetricPollDate()).modifyDate(in.getModifyDate()).notes(in.getNotes()).privateNetworkOnly(in.isPrivateNetworkOnly()).startCpus(in.getStartCpus()).statusId(in.getStatusId()).uuid(in.getUuid()).primaryBackendIpAddress(in.getPrimaryBackendIpAddress()).primaryIpAddress(in.getPrimaryIpAddress()).billingItemId(in.getBillingItemId()).operatingSystem(in.getOperatingSystem()).datacenter(in.getDatacenter()).powerState(in.getPowerState());
        }
    }
}

