/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Provides;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.RequiresHttp;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.trmk.ecloud.TerremarkECloudAsyncClient;
import org.jclouds.trmk.ecloud.TerremarkECloudClient;
import org.jclouds.trmk.ecloud.features.DataCenterOperationsAsyncClient;
import org.jclouds.trmk.ecloud.features.DataCenterOperationsClient;
import org.jclouds.trmk.ecloud.features.TagOperationsAsyncClient;
import org.jclouds.trmk.ecloud.features.TagOperationsClient;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.config.DefaultVCloudReferencesModule;
import org.jclouds.trmk.vcloud_0_8.config.TerremarkVCloudRestClientModule;
import org.jclouds.trmk.vcloud_0_8.domain.Network;
import org.jclouds.trmk.vcloud_0_8.domain.NetworkExtendedInfo;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;

@RequiresHttp
@ConfiguresRestClient
public class TerremarkECloudRestClientModule
extends TerremarkVCloudRestClientModule<TerremarkECloudClient, TerremarkECloudAsyncClient> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(DataCenterOperationsClient.class, DataCenterOperationsAsyncClient.class).put(TagOperationsClient.class, TagOperationsAsyncClient.class).build();

    public TerremarkECloudRestClientModule() {
        super(TerremarkECloudClient.class, TerremarkECloudAsyncClient.class, DELEGATE_MAP);
    }

    @Provides
    @Singleton
    protected TerremarkVCloudAsyncClient provideTerremarkAsyncClient(TerremarkECloudAsyncClient in) {
        return in;
    }

    @Provides
    @Singleton
    protected TerremarkVCloudClient provideTerremarkClient(TerremarkECloudClient in) {
        return in;
    }

    @Override
    protected void installDefaultVCloudEndpointsModule() {
        this.install(new DefaultVCloudReferencesModule(){

            @Override
            protected Predicate<ReferenceType> provideDefaultNetworkSelector(Injector i) {
                return i.getInstance(IsDMZNetwork.class);
            }
        });
    }

    @Singleton
    public static class IsDMZNetwork
    implements Predicate<ReferenceType> {
        private final TerremarkECloudClient client;

        @Inject
        public IsDMZNetwork(TerremarkECloudClient client) {
            this.client = client;
        }

        @Override
        public boolean apply(ReferenceType arg0) {
            Network orgNetwork = this.client.getNetwork(arg0.getHref());
            NetworkExtendedInfo terremarkNetwork = this.client.getNetworkExtendedInfo(Preconditions.checkNotNull(Preconditions.checkNotNull(orgNetwork, "network at: " + arg0).getNetworkExtension(), "network extension for: " + arg0).getHref());
            return Preconditions.checkNotNull(terremarkNetwork, "terremark network extension at: " + orgNetwork.getNetworkExtension()).getNetworkType() == NetworkExtendedInfo.Type.DMZ;
        }
    }
}

