/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.util.Patterns;
import org.jclouds.util.Strings2;

@Singleton
public class BindAddInternetServiceToXmlPayload
implements MapBinder {
    @Inject
    @Named(value="CreateInternetService")
    private String xmlTemplate;
    @Inject
    private BindToStringPayload stringBinder;
    @Inject
    @Named(value="jclouds.terremark.extension.ns")
    private String ns;

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        String name = Preconditions.checkNotNull(postParams.get("name"), "name parameter not present");
        String protocol = Preconditions.checkNotNull(postParams.get("protocol"), "protocol parameter not present");
        String port = Preconditions.checkNotNull(postParams.get("port"), "port parameter not present");
        String enabled = Preconditions.checkNotNull(postParams.get("enabled"), "enabled parameter not present");
        String description = postParams.get("description");
        String payload = Strings2.replaceTokens(this.xmlTemplate, ImmutableMap.of("name", name, "protocol", protocol, "port", port, "enabled", enabled, "ns", this.ns));
        try {
            payload = Strings2.replaceAll(payload, Patterns.TOKEN_TO_PATTERN.get("description"), description == null ? "" : String.format("\n\t<Description>%s</Description>", description));
            payload = Strings2.replaceAll(payload, Patterns.TOKEN_TO_PATTERN.get("monitor"), this.getMonitorString(postParams));
        }
        catch (ExecutionException e) {
            Throwables.propagate(e);
        }
        return this.stringBinder.bindToRequest(request, payload);
    }

    private String getMonitorString(Map<String, String> postParams) {
        String monitor = postParams.get("monitor");
        if (monitor == null || "true".equalsIgnoreCase(monitor)) {
            return "";
        }
        return "\n\t<Monitor><MonitorType>Disabled</MonitorType></Monitor>";
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("CreateInternetService needs parameters");
    }
}

