/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.util.Patterns;
import org.jclouds.util.Strings2;

@Singleton
public class BindAddNodeServiceToXmlPayload
implements MapBinder {
    @Inject
    @Named(value="CreateNodeService")
    private String xmlTemplate;
    @Inject
    private BindToStringPayload stringBinder;
    @Inject
    @Named(value="jclouds.terremark.extension.ns")
    private String ns;

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        String ipAddress = Preconditions.checkNotNull(postParams.get("ipAddress"), "ipAddress parameter not present");
        String name = Preconditions.checkNotNull(postParams.get("name"), "name parameter not present");
        String port = Preconditions.checkNotNull(postParams.get("port"), "port parameter not present");
        String enabled = Preconditions.checkNotNull(postParams.get("enabled"), "enabled parameter not present");
        String description = postParams.get("description");
        String payload = Strings2.replaceTokens(this.xmlTemplate, ImmutableMap.of("name", name, "ipAddress", ipAddress, "port", port, "enabled", enabled, "ns", this.ns));
        try {
            payload = Strings2.replaceAll(payload, Patterns.TOKEN_TO_PATTERN.get("description"), description == null ? "" : String.format("\n    <Description>%s</Description>", description));
        }
        catch (ExecutionException e) {
            Throwables.propagate(e);
        }
        return this.stringBinder.bindToRequest(request, payload);
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("CreateNodeService needs parameters");
    }
}

