/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.config.BindComputeSuppliersByClass;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.trmk.vcloud_0_8.compute.suppliers.OrgAndVDCToLocationSupplier;
import org.jclouds.trmk.vcloud_0_8.compute.suppliers.StaticHardwareSupplier;
import org.jclouds.trmk.vcloud_0_8.compute.suppliers.VAppTemplatesInOrgs;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.VDC;

public class TerremarkBindComputeSuppliersByClass
extends BindComputeSuppliersByClass {
    @Override
    protected Class<? extends Supplier<Set<? extends Hardware>>> defineHardwareSupplier() {
        return StaticHardwareSupplier.class;
    }

    @Override
    protected Class<? extends Supplier<Set<? extends Location>>> defineLocationSupplier() {
        return OrgAndVDCToLocationSupplier.class;
    }

    @Override
    protected Class<? extends Supplier<Location>> defineDefaultLocationSupplier() {
        return DefaultVDC.class;
    }

    @Override
    protected Class<? extends Supplier<Set<? extends Image>>> defineImageSupplier() {
        return VAppTemplatesInOrgs.class;
    }

    @Singleton
    public static class DefaultVDC
    implements Supplier<Location> {
        private final Supplier<Set<? extends Location>> locationsSupplier;
        private final IsDefaultVDC isDefaultVDC;

        @Inject
        DefaultVDC(@Memoized Supplier<Set<? extends Location>> locationsSupplier, IsDefaultVDC isDefaultVDC) {
            this.locationsSupplier = Preconditions.checkNotNull(locationsSupplier, "locationsSupplierSupplier");
            this.isDefaultVDC = Preconditions.checkNotNull(isDefaultVDC, "isDefaultVDC");
        }

        @Override
        public Location get() {
            return Iterables.find((Iterable)this.locationsSupplier.get(), this.isDefaultVDC);
        }

        @Singleton
        public static final class IsDefaultVDC
        implements Predicate<Location> {
            private final ReferenceType defaultVDC;

            @Inject
            IsDefaultVDC(@VDC ReferenceType defaultVDC) {
                this.defaultVDC = Preconditions.checkNotNull(defaultVDC, "defaultVDC");
            }

            @Override
            public boolean apply(Location input) {
                return input.getScope() == LocationScope.ZONE && input.getId().equals(this.defaultVDC.getHref().toASCIIString());
            }

            public String toString() {
                return "isDefaultVDC()";
            }
        }
    }
}

