/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.trmk.vcloud_0_8.compute.domain.OrgAndName;
import org.jclouds.trmk.vcloud_0_8.compute.strategy.DeleteKeyPair;

@Singleton
public class CleanupOrphanKeys {
    final Function<NodeMetadata, OrgAndName> nodeToOrgAndName;
    final DeleteKeyPair deleteKeyPair;
    final ListNodesStrategy listNodes;
    final Map<String, Credentials> credentialStore;

    @Inject
    CleanupOrphanKeys(Function<NodeMetadata, OrgAndName> nodeToOrgAndName, DeleteKeyPair deleteKeyPair, Map<String, Credentials> credentialStore, ListNodesStrategy listNodes) {
        this.nodeToOrgAndName = nodeToOrgAndName;
        this.deleteKeyPair = deleteKeyPair;
        this.listNodes = listNodes;
        this.credentialStore = credentialStore;
    }

    public void execute(Iterable<? extends NodeMetadata> deadOnes) {
        for (NodeMetadata nodeMetadata : deadOnes) {
            this.credentialStore.remove("node#" + nodeMetadata.getId());
        }
        Iterable<OrgAndName> orgGroups = Iterables.filter(Iterables.transform(deadOnes, this.nodeToOrgAndName), Predicates.notNull());
        for (OrgAndName orgGroup : orgGroups) {
            Iterable<? extends NodeMetadata> nodesInOrg = this.listNodes.listDetailsOnNodesMatching(NodePredicates.parentLocationId(orgGroup.getOrg().toASCIIString()));
            Iterable<NodeMetadata> nodesInGroup = Iterables.filter(nodesInOrg, NodePredicates.inGroup(orgGroup.getName()));
            if (Iterables.size(nodesInGroup) != 0 && !Iterables.all(nodesInGroup, NodePredicates.TERMINATED)) continue;
            this.deleteKeyPair.execute(orgGroup);
        }
    }
}

