/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.Org;

@Singleton
public class VCloudImageSupplier
implements Supplier<Set<? extends Image>> {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    private final Supplier<Map<String, ? extends Org>> orgMap;
    private final Function<Org, Iterable<? extends Image>> imagesInOrg;
    private final ExecutorService executor;

    @Inject
    VCloudImageSupplier(Supplier<Map<String, ? extends Org>> orgMap, Function<Org, Iterable<? extends Image>> imagesInOrg, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.orgMap = Preconditions.checkNotNull(orgMap, "orgMap");
        this.imagesInOrg = Preconditions.checkNotNull(imagesInOrg, "imagesInOrg");
        this.executor = Preconditions.checkNotNull(executor, "executor");
    }

    @Override
    public Set<? extends Image> get() {
        Iterable orgs = Preconditions.checkNotNull(this.orgMap.get().values(), "orgs");
        Iterable<Iterable<? extends Image>> images = FutureIterables.transformParallel(orgs, new Function<Org, Future<Iterable<? extends Image>>>(){

            @Override
            public Future<Iterable<? extends Image>> apply(final Org from) {
                Preconditions.checkNotNull(from, "org");
                return VCloudImageSupplier.this.executor.submit(new Callable<Iterable<? extends Image>>(){

                    @Override
                    public Iterable<? extends Image> call() throws Exception {
                        return (Iterable)VCloudImageSupplier.this.imagesInOrg.apply(from);
                    }

                    public String toString() {
                        return "imagesInOrg(" + from.getHref() + ")";
                    }
                });
            }
        }, this.executor, null, this.logger, "images in " + orgs);
        return Sets.newLinkedHashSet(Iterables.concat(images));
    }
}

