/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudSession;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;
import org.jclouds.trmk.vcloud_0_8.suppliers.OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault;

@Singleton
public class DefaultOrgForUser
implements Function<String, ReferenceType> {
    private final OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault selector;
    private final Supplier<VCloudSession> sessionSupplier;

    @Inject
    public DefaultOrgForUser(ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull, @Org Predicate<ReferenceType> defaultSelector, Supplier<VCloudSession> sessionSupplier) {
        this.selector = new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault(Preconditions.checkNotNull(valueOfConfigurationKeyOrNull, "valueOfConfigurationKeyOrNull"), "jclouds.vcloud.defaults.org", Preconditions.checkNotNull(defaultSelector, "defaultSelector"));
        this.sessionSupplier = Preconditions.checkNotNull(sessionSupplier, "sessionSupplier");
    }

    @Override
    public ReferenceType apply(String user) {
        VCloudSession session = this.sessionSupplier.get();
        Preconditions.checkState(session != null, "could not retrieve Session at %s", user);
        return this.selector.apply((Iterable<ReferenceType>)session.getOrgs().values());
    }
}

