/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import java.net.URI;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.trmk.vcloud_0_8.config.DefaultCatalogForOrg;
import org.jclouds.trmk.vcloud_0_8.config.DefaultNetworkForVDC;
import org.jclouds.trmk.vcloud_0_8.config.DefaultOrgForUser;
import org.jclouds.trmk.vcloud_0_8.config.DefaultTasksListForOrg;
import org.jclouds.trmk.vcloud_0_8.config.DefaultVDCForOrg;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Network;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;
import org.jclouds.trmk.vcloud_0_8.endpoints.TasksList;
import org.jclouds.trmk.vcloud_0_8.endpoints.VDC;

public class DefaultVCloudReferencesModule
extends AbstractModule {
    @Override
    protected void configure() {
    }

    @Provides
    @Org
    @Singleton
    protected ReferenceType provideDefaultOrg(DefaultOrgForUser defaultOrgURIForUser, @Named(value="jclouds.identity") String user) {
        return defaultOrgURIForUser.apply(user);
    }

    @Provides
    @Singleton
    @Org
    protected Predicate<ReferenceType> provideDefaultOrgSelector(Injector i) {
        return Predicates.alwaysTrue();
    }

    @Provides
    @TasksList
    @Singleton
    protected ReferenceType provideDefaultTasksList(DefaultTasksListForOrg defaultTasksListURIForOrg, @Org ReferenceType defaultOrg) {
        return defaultTasksListURIForOrg.apply(defaultOrg);
    }

    @Provides
    @Singleton
    @TasksList
    protected Predicate<ReferenceType> provideDefaultTasksListSelector(Injector i) {
        return Predicates.alwaysTrue();
    }

    @Provides
    @org.jclouds.trmk.vcloud_0_8.endpoints.Catalog
    @Singleton
    protected ReferenceType provideDefaultCatalog(DefaultCatalogForOrg defaultCatalogURIForOrg, @Org ReferenceType defaultOrg) {
        return defaultCatalogURIForOrg.apply(defaultOrg);
    }

    @Provides
    @Singleton
    @org.jclouds.trmk.vcloud_0_8.endpoints.Catalog
    protected Predicate<ReferenceType> provideDefaultCatalogSelector(Injector i) {
        return Predicates.alwaysTrue();
    }

    @Provides
    @Singleton
    protected Supplier<Map<URI, ? extends Catalog>> provideCatalogsById(Supplier<Map<String, Map<String, ? extends Catalog>>> supplier) {
        return Suppliers.compose(new Function<Map<String, Map<String, ? extends Catalog>>, Map<URI, ? extends Catalog>>(){

            @Override
            public Map<URI, ? extends Catalog> apply(Map<String, Map<String, ? extends Catalog>> arg0) {
                ImmutableMap.Builder<URI, Catalog> builder = ImmutableMap.builder();
                for (Map<String, ? extends Catalog> v1 : arg0.values()) {
                    for (Catalog catalog : v1.values()) {
                        builder.put(catalog.getHref(), catalog);
                    }
                }
                return builder.build();
            }
        }, supplier);
    }

    @Provides
    @VDC
    @Singleton
    protected ReferenceType provideDefaultVDC(DefaultVDCForOrg defaultVDCURIForOrg, @Org ReferenceType defaultOrg) {
        return defaultVDCURIForOrg.apply(defaultOrg);
    }

    @Provides
    @Singleton
    @VDC
    protected Predicate<ReferenceType> provideDefaultVDCSelector(Injector i) {
        return Predicates.alwaysTrue();
    }

    @Provides
    @Network
    @Singleton
    protected ReferenceType provideDefaultNetwork(DefaultNetworkForVDC defaultNetworkURIForVDC, @VDC ReferenceType defaultVDC) {
        return defaultNetworkURIForVDC.apply(defaultVDC);
    }

    @Provides
    @Singleton
    @Network
    protected Predicate<ReferenceType> provideDefaultNetworkSelector(Injector i) {
        return Predicates.alwaysTrue();
    }
}

