/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain;

import org.jclouds.trmk.vcloud_0_8.domain.Subnet;

public class NetworkAdapter
implements Comparable<NetworkAdapter> {
    private final String macAddress;
    private final String name;
    private final Subnet subnet;

    public NetworkAdapter(String macAddress, String name, Subnet subnet) {
        this.macAddress = macAddress;
        this.name = name;
        this.subnet = subnet;
    }

    @Override
    public int compareTo(NetworkAdapter that) {
        return this == that ? 0 : this.getMacAddress().compareTo(that.getMacAddress());
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getName() {
        return this.name;
    }

    public Subnet getSubnet() {
        return this.subnet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.macAddress == null ? 0 : this.macAddress.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.subnet == null ? 0 : this.subnet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkAdapter other = (NetworkAdapter)obj;
        if (this.macAddress == null ? other.macAddress != null : !this.macAddress.equals(other.macAddress)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.subnet == null ? other.subnet != null : !this.subnet.equals(other.subnet));
    }

    public String toString() {
        return "[MAC address=" + this.macAddress + ", name=" + this.name + ", subnet=" + this.subnet + "]";
    }
}

