/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;

@Singleton
public class AllVDCsInOrg
implements Function<Org, Iterable<? extends VDC>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final TerremarkVCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    AllVDCsInOrg(TerremarkVCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    @Override
    public Iterable<? extends VDC> apply(Org org) {
        Iterable<VDC> catalogItems = FutureIterables.transformParallel(org.getVDCs().values(), new Function<ReferenceType, Future<VDC>>(){

            @Override
            public Future<VDC> apply(ReferenceType from) {
                return AllVDCsInOrg.this.aclient.getVDC(from.getHref());
            }
        }, this.executor, null, this.logger, "vdcs in org " + org.getName());
        return catalogItems;
    }
}

