/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Catalog;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;

@Singleton
public class OrgNameAndCatalogNameToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgMap;
    private final ReferenceType defaultOrg;
    private final ReferenceType defaultCatalog;

    @Inject
    public OrgNameAndCatalogNameToEndpoint(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgMap, @Org ReferenceType defaultOrg, @Catalog ReferenceType defaultCatalog) {
        this.orgMap = orgMap;
        this.defaultOrg = defaultOrg;
        this.defaultCatalog = defaultCatalog;
    }

    @Override
    public URI apply(Object from) {
        Iterable orgCatalog = (Iterable)Preconditions.checkNotNull(from, "args");
        Object org = Iterables.get(orgCatalog, 0);
        Object catalog = Iterables.get(orgCatalog, 1);
        if (org == null && catalog == null) {
            return this.defaultCatalog.getHref();
        }
        if (org == null) {
            org = this.defaultOrg.getName();
        }
        try {
            Map<String, ReferenceType> catalogs = Preconditions.checkNotNull(this.orgMap.get().get(org)).getCatalogs();
            return catalog == null ? Iterables.getLast(catalogs.values()).getHref() : catalogs.get(catalog).getHref();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(org + "/" + catalog + " not found in " + this.orgMap.get());
        }
    }
}

